/*
 * Decompiled with CFR 0.152.
 */
package br.net.fabiozumbi12.RankUpper.config;

import br.net.fabiozumbi12.RankUpper.RUUtil;
import br.net.fabiozumbi12.RankUpper.RankUpper;
import br.net.fabiozumbi12.RankUpper.config.MainCategory;
import br.net.fabiozumbi12.RankUpper.config.RankedGroupsCategory;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.rojo8399.placeholderapi.PlaceholderService;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.GuiceObjectMapperFactory;
import ninja.leaping.configurate.objectmapping.ObjectMapperFactory;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.statistic.Statistic;
import org.spongepowered.api.text.Text;

public class RUConfig {
    private CommentedConfigurationNode configRoot;
    private ConfigurationLoader<CommentedConfigurationNode> cfgLoader;
    private MainCategory root;

    public MainCategory root() {
        return this.root;
    }

    public RUConfig(GuiceObjectMapperFactory factory) {
        try {
            Files.createDirectories(RankUpper.get().getConfigDir().toPath(), new FileAttribute[0]);
            File defConfig = new File(RankUpper.get().getConfigDir(), "rankupper.conf");
            if (!defConfig.exists()) {
                RankUpper.get().getLogger().log("Creating config file...");
                defConfig.createNewFile();
            }
            this.cfgLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(defConfig)).build();
            this.configRoot = (CommentedConfigurationNode)this.cfgLoader.load(ConfigurationOptions.defaults().setObjectMapperFactory((ObjectMapperFactory)factory).setShouldCopyDefaults(true));
            this.root = (MainCategory)this.configRoot.getValue(TypeToken.of(MainCategory.class), (Object)new MainCategory());
            if (this.root.ranked_groups.isEmpty()) {
                RankedGroupsCategory rgc = new RankedGroupsCategory(Arrays.asList("lp user {player} parent unset {oldgroup}", "lp user {player} parent set {newgroup}", "xp 50L {player}"), 50, "&a>> The player &6{player} &ahas played for &6{time} &aand now is rank {newgroup} of server.", 120, 1000, "member");
                rgc.minecraft_statistic.put("MOB_KILLS", 100L);
                rgc.minecraft_scoreboards.put("TeamBlue", 50L);
                rgc.placeholder_api_requirements.put("%Pokedex%", 200L);
                this.root.ranked_groups.put("group-example", rgc);
            }
            for (RankedGroupsCategory group : this.root.ranked_groups.values()) {
                if (group.minecraft_statistic.isEmpty()) {
                    group.minecraft_statistic.put("MOB_KILLS", -1L);
                }
                if (group.minecraft_scoreboards.isEmpty()) {
                    group.minecraft_scoreboards.put("TeamBlue", -1L);
                }
                if (!group.placeholder_api_requirements.isEmpty()) continue;
                group.placeholder_api_requirements.put("%Pokedex%", -1L);
            }
        }
        catch (IOException e1) {
            RankUpper.get().getLogger().severe("The default configuration could not be loaded or created!");
            e1.printStackTrace();
            return;
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
        this.save();
        RankUpper.get().getLogger().log("All configurations loaded!");
    }

    private void save() {
        try {
            this.configRoot.setValue(TypeToken.of(MainCategory.class), (Object)this.root);
            this.cfgLoader.save((ConfigurationNode)this.configRoot);
        }
        catch (IOException | ObjectMappingException e) {
            RankUpper.get().getLogger().severe("Problems during save file:");
            e.printStackTrace();
        }
    }

    private boolean groupExists(String group) {
        return this.root.ranked_groups.containsKey(group);
    }

    public boolean addGroup(String group, String newGroup, int time, int levels, int money) {
        if (this.groupExists(group)) {
            return false;
        }
        List<String> cmds = Arrays.asList("lp user {player} parent unset {oldgroup}", "lp user {player} parent set {newgroup}");
        RankedGroupsCategory groupvalues = new RankedGroupsCategory(cmds, levels, "&a>> The player &6{player} &ahas played for &6{time} &aand now is rank {newgroup} on server.", time, money, newGroup);
        this.root.ranked_groups.put(group, groupvalues);
        this.save();
        return true;
    }

    public Boolean setGroup(String group, String newGroup, int time, int levels, int money) {
        if (!this.groupExists(group)) {
            return false;
        }
        this.root.ranked_groups.get((Object)group).minutes_needed = time;
        this.root.ranked_groups.get((Object)group).levels_needed = levels;
        this.root.ranked_groups.get((Object)group).money_needed = money;
        this.root.ranked_groups.get((Object)group).next_group = newGroup;
        this.save();
        return true;
    }

    public boolean checkRankup(User p) {
        Object acc;
        Optional phapiOpt;
        String ngroup;
        Subject subG = RankUpper.get().getPerms().getHighestGroup(p);
        String pgroup = null;
        if (subG == null) {
            List<Subject> pgroups = RankUpper.get().getPerms().getPlayerGroups(p);
            for (Subject sub : pgroups) {
                if (!this.root.ranked_groups.containsKey(sub.getIdentifier())) continue;
                pgroup = sub.getIdentifier();
                RankUpper.get().getLogger().debug("Ranked Player Group (not primary) is: " + pgroup);
                break;
            }
            if (pgroup == null) {
                return false;
            }
        } else {
            pgroup = subG.getIdentifier();
            RankUpper.get().getLogger().debug("Highest Group is: " + pgroup);
        }
        String string = ngroup = this.root.ranked_groups.get(pgroup) != null ? this.root.ranked_groups.get((Object)pgroup).next_group : null;
        if (ngroup == null || ngroup.isEmpty() || !RankUpper.get().getPerms().getAllGroups().contains(ngroup)) {
            return false;
        }
        int minutesNeeded = this.root.ranked_groups.get((Object)pgroup).minutes_needed;
        int moneyNeeded = this.root.ranked_groups.get((Object)pgroup).money_needed;
        int levelNeeded = this.root.ranked_groups.get((Object)pgroup).levels_needed;
        for (Map.Entry<String, Long> key : this.root.ranked_groups.get((Object)pgroup).minecraft_statistic.entrySet()) {
            if (key.getValue() <= 0L || !Sponge.getRegistry().getType(Statistic.class, key.getKey()).isPresent()) continue;
            Statistic stat = (Statistic)Sponge.getRegistry().getType(Statistic.class, key.getKey()).get();
            try {
                if (p.getStatisticData().get((Object)stat).isPresent() && (Long)p.getStatisticData().get((Object)stat).get() >= key.getValue()) continue;
                return false;
            }
            catch (Exception ignored) {
                return false;
            }
        }
        if (Sponge.getServer().getServerScoreboard().isPresent()) {
            for (Map.Entry<String, Long> key : this.root.ranked_groups.get((Object)pgroup).minecraft_scoreboards.entrySet()) {
                Score score;
                if (key.getValue() <= 0L || ((Scoreboard)Sponge.getServer().getServerScoreboard().get()).getScores((Text)Text.of((String)key.getKey())).isEmpty() || (long)(score = (Score)((Scoreboard)Sponge.getServer().getServerScoreboard().get()).getScores((Text)Text.of((String)key.getKey())).stream().findFirst().get()).getScore() >= key.getValue()) continue;
                return false;
            }
        }
        if (Sponge.getPluginManager().getPlugin("placeholderapi").isPresent() && (phapiOpt = Sponge.getServiceManager().provide(PlaceholderService.class)).isPresent()) {
            PlaceholderService phapi = (PlaceholderService)phapiOpt.get();
            for (Map.Entry<String, Long> key : this.root.ranked_groups.get((Object)pgroup).placeholder_api_requirements.entrySet()) {
                Optional optVal = phapi.parse(key.getKey(), p.getPlayer().isPresent() ? p.getPlayer().get() : p, null, Long.class);
                if (key.getValue() <= 0L || !optVal.isPresent() || (Long)optVal.get() >= key.getValue()) continue;
                return false;
            }
        }
        if (minutesNeeded > 0 && RankUpper.get().getStats().getPlayerTime(RankUpper.get().getStats().getPlayerKey(p)) < minutesNeeded) {
            return false;
        }
        if (moneyNeeded > 0 && RankUpper.get().getEconomy() != null && (acc = (UniqueAccount)RankUpper.get().getEconomy().getOrCreateAccount(p.getUniqueId()).get()).getBalance(RankUpper.get().getEconomy().getDefaultCurrency()).intValue() < moneyNeeded) {
            return false;
        }
        if (levelNeeded > 0 && p.get(Keys.EXPERIENCE_LEVEL).isPresent() && (Integer)p.get(Keys.EXPERIENCE_LEVEL).get() < levelNeeded) {
            return false;
        }
        for (String cmd : this.root.ranked_groups.get((Object)pgroup).execute_commands) {
            RankUpper.get().game.getCommandManager().process((CommandSource)Sponge.getServer().getConsole(), cmd.replace("{player}", p.getName()).replace("{oldgroup}", pgroup).replace("{newgroup}", ngroup));
        }
        String message = this.root.ranked_groups.get((Object)pgroup).message_broadcast;
        if (message != null && !message.equals("")) {
            Sponge.getServer().getBroadcastChannel().send(RUUtil.toText(message.replace("{player}", p.getName()).replace("{time}", RUUtil.timeDescript(minutesNeeded)).replace("{newgroup}", ngroup)));
        }
        return true;
    }
}

