/*
 * Decompiled with CFR 0.152.
 */
package br.net.fabiozumbi12.RankUpper;

import br.net.fabiozumbi12.RankUpper.RankUpper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;

public class RUUtil {
    public static String DateNow() {
        SimpleDateFormat df = new SimpleDateFormat(RankUpper.get().getConfig().root().date_format);
        Date today = Calendar.getInstance().getTime();
        return df.format(today);
    }

    public static String timeDescript(int timeNeeded) {
        long day = TimeUnit.MINUTES.toDays(timeNeeded);
        long hours = TimeUnit.MINUTES.toHours((long)timeNeeded - TimeUnit.DAYS.toMinutes(day));
        long minutes = TimeUnit.MINUTES.toMinutes((long)timeNeeded - TimeUnit.DAYS.toMinutes(day) - TimeUnit.HOURS.toMinutes(hours));
        StringBuilder msg = new StringBuilder();
        if (day > 0L) {
            msg.append(day).append(" ").append(RankUpper.get().getLang().get("config.day")).append(", ");
        }
        if (hours > 0L) {
            msg.append(hours).append(" ").append(RankUpper.get().getLang().get("config.hour")).append(", ");
        }
        if (minutes > 0L) {
            msg.append(minutes).append(" ").append(RankUpper.get().getLang().get("config.minute")).append(", ");
        }
        try {
            msg = msg.replace(msg.lastIndexOf(","), msg.lastIndexOf(",") + 1, "");
            if (msg.toString().contains(",")) {
                msg = msg.replace(msg.lastIndexOf(","), msg.lastIndexOf(",") + 1, " " + RankUpper.get().getLang().get("config.and"));
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            return RankUpper.get().getLang().get("config.lessThan");
        }
        if (msg.toString().endsWith(" ")) {
            return msg.toString().substring(0, msg.toString().length() - 1);
        }
        return msg.toString();
    }

    public static Map<String, Integer> sort(Map<String, Integer> unsortMap) {
        LinkedList<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(unsortMap.entrySet());
        list.sort((o2, o1) -> ((Integer)o1.getValue()).compareTo((Integer)o2.getValue()));
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedMap;
    }

    public static Text toText(String str) {
        return TextSerializers.FORMATTING_CODE.deserialize(str);
    }
}

