/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder.storage;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.github.aquerr.worldrebuilder.entity.Region;
import io.github.aquerr.worldrebuilder.storage.HOCONStorage;
import io.github.aquerr.worldrebuilder.storage.Storage;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.config.ConfigDir;

@Singleton
public class StorageManager {
    private final Storage storage;

    @Inject
    public StorageManager(@ConfigDir(sharedRoot=false) Path configDir) {
        this.storage = new HOCONStorage(configDir);
    }

    public List<Region> getRegions() {
        try {
            return this.storage.getRegions();
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public void addRegion(Region region) {
        try {
            this.storage.addRegion(region);
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
    }

    public void updateRegion(Region region) {
        try {
            this.storage.addRegion(region);
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
    }

    public Region getRegion(String name) {
        try {
            return this.storage.getRegion(name);
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void deleteRegion(String name) {
        this.storage.deleteRegion(name);
    }
}

