/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder.listener;

import io.github.aquerr.worldrebuilder.WorldRebuilder;
import io.github.aquerr.worldrebuilder.entity.Region;
import io.github.aquerr.worldrebuilder.listener.AbstractListener;
import io.github.aquerr.worldrebuilder.scheduling.RebuildBlocksTask;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.LocatableBlock;

public class BlockBreakListener
extends AbstractListener {
    public BlockBreakListener(WorldRebuilder plugin) {
        super(plugin);
    }

    @Listener(order=Order.LAST)
    public void onBlockBreak(ChangeBlockEvent.Break event) {
        LocatableBlock locatableBlock = null;
        if (event.getSource() instanceof LocatableBlock) {
            locatableBlock = (LocatableBlock)event.getSource();
        }
        if (locatableBlock != null && (locatableBlock.getBlockState().getType() == BlockTypes.FLOWING_WATER || locatableBlock.getBlockState().getType() == BlockTypes.FLOWING_LAVA)) {
            return;
        }
        Collection<Region> regions = super.getPlugin().getRegionManager().getRegions();
        if (regions.size() == 0) {
            return;
        }
        List transactions = event.getTransactions();
        UUID worldUUID = ((BlockSnapshot)((Transaction)transactions.get(0)).getOriginal()).getWorldUniqueId();
        CompletableFuture.runAsync(() -> this.rebuildBlocks(worldUUID, new LinkedList<Transaction<BlockSnapshot>>(transactions)));
    }

    private void rebuildBlocks(UUID worldUUID, List<Transaction<BlockSnapshot>> transactions) {
        Collection<Region> regions = super.getPlugin().getRegionManager().getRegions();
        LinkedList<BlockSnapshot> blocksToRestore = new LinkedList<BlockSnapshot>();
        Region affectedRegion = null;
        for (Region region : regions) {
            if (!region.isActive()) continue;
            for (Transaction<BlockSnapshot> transaction : transactions) {
                if (!region.intersects(worldUUID, ((BlockSnapshot)transaction.getOriginal()).getPosition())) continue;
                blocksToRestore.add((BlockSnapshot)transaction.getOriginal());
                affectedRegion = region;
            }
        }
        if (affectedRegion == null) {
            return;
        }
        super.getPlugin().getWorldRebuilderScheduler().scheduleRebuildBlocksTask(new RebuildBlocksTask(worldUUID, blocksToRestore), affectedRegion.getRestoreTime());
    }
}

