/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.component.ItemTransformComponent;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.registry.ClientRegistry;
import net.malisis.core.renderer.IItemRenderer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@AutoLoad
@SideOnly(value=Side.CLIENT)
public class EmptyModelLoader
implements ICustomModelLoader {
    private static EmptyModelLoader INSTANCE = new EmptyModelLoader();
    private Map<ResourceLocation, DummyModel> locations = Maps.newHashMap();

    private EmptyModelLoader() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)this);
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return this.locations.containsKey(modelLocation);
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        return this.locations.get(modelLocation);
    }

    public void func_110549_a(IResourceManager resourceManager) {
    }

    public static void register(Item item) {
        ModelResourceLocation mrl = new ModelResourceLocation(item.getRegistryName(), "inventory");
        EmptyModelLoader.register(item, mrl);
    }

    public static void register(Item item, ModelResourceLocation mrl) {
        EmptyModelLoader.INSTANCE.locations.put((ResourceLocation)mrl, new DummyModel(item));
        ModelLoader.setCustomMeshDefinition((Item)item, stack -> mrl);
    }

    public static class DummyModel
    implements IBakedModel,
    IModel {
        private Item item;
        private ModelResourceLocation mrl;

        public DummyModel(Item item) {
            this.item = item;
            this.mrl = new ModelResourceLocation(item.getRegistryName(), "inventory");
        }

        public ModelResourceLocation getResourceLocation() {
            return this.mrl;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType transformType) {
            ItemTransformComponent itc = IComponent.getComponent(ItemTransformComponent.class, this.item);
            if (itc != null) {
                return Pair.of((Object)this, (Object)itc.getTransform(this.item, transformType));
            }
            IItemRenderer itemRenderer = ClientRegistry.getItemRenderer(this.item);
            if (itemRenderer == null) {
                return Pair.of((Object)this, null);
            }
            itemRenderer.setTransformType(transformType);
            return Pair.of((Object)this, (Object)itemRenderer.getTransform(this.item, transformType));
        }

        public boolean func_177556_c() {
            IItemRenderer itemRenderer = ClientRegistry.getItemRenderer(this.item);
            return itemRenderer != null && itemRenderer.isGui3d();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            return ImmutableList.of();
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            return this;
        }

        public String toString() {
            return this.item.getRegistryName() + "[" + this.mrl + "]";
        }
    }
}

