/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions.command;

import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import pw.aaron1011.rentableregions.RentableRegions;
import pw.aaron1011.rentableregions.command.RentableRegionsCommand;
import pw.aaron1011.rentableregions.data.RentedRegion;

public class OwnerCommand
implements CommandExecutor {
    public static CommandSpec create() {
        return CommandSpec.builder().description((Text)Text.of((String)"Transfers ownership of a rental")).arguments(new CommandElement[]{RentableRegionsCommand.getOwnRegionElement(), GenericArguments.user((Text)Text.of((String)"player"))}).permission("rentableregions.command.owner").executor((CommandExecutor)new OwnerCommand()).build();
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (!(src instanceof Player)) {
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You must be a player to run this command!"}));
            return CommandResult.empty();
        }
        RentedRegion region = (RentedRegion)args.getOne((Text)Text.of((String)"region")).get();
        User user = (User)args.getOne((Text)Text.of((String)"player")).get();
        String regionName = region.name;
        UUID playerUUID = ((Player)src).getUniqueId();
        UUID userUUID = user.getUniqueId();
        src.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "You are about to transfer ownership of region " + regionName + " to " + user.getName() + " . To confirm, run "}).concat(RentableRegionsCommand.getConfirmText()));
        RentableRegions.onConfirm((Player)src, player -> {
            Optional<RentedRegion> rentedRegion = RentableRegions.getRegionsData().getRegion(regionName);
            if (!rentedRegion.isPresent()) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Region " + regionName + " no longer exists!"}));
                return;
            }
            if (!region.isRented() || !region.owner.equals(player.getUniqueId())) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not own region " + region.name}));
                return;
            }
            Optional<Text> error = RentableRegions.canRent(user, region);
            if (error.isPresent()) {
                player.sendMessage(Text.of((String)("Cannot transfer ownership of region to " + user.getName() + ": ")).concat(error.get()));
                return;
            }
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "You transferrred ownership of region " + regionName + " to " + user.getName()}));
            user.getPlayer().ifPresent(p -> p.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "You are now the owner of region " + regionName})));
            region.owner = userUUID;
            RentableRegions.INSTANCE.saveRegionsData();
            RentableRegions.getPlayerData((UUID)playerUUID).rentedRegions.remove(rentedRegion.get().name);
            RentableRegions.getPlayerData((UUID)userUUID).rentedRegions.add(rentedRegion.get().name);
            RentableRegions.savePlayerData(playerUUID);
            RentableRegions.savePlayerData(userUUID);
            region.removeMember(playerUUID, false);
            region.addMember(user, false);
        });
        return CommandResult.success();
    }
}

