/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions.command;

import java.time.Duration;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import pw.aaron1011.rentableregions.RentableRegions;
import pw.aaron1011.rentableregions.command.RentableRegionsCommand;
import pw.aaron1011.rentableregions.data.RentedRegion;

public class AdminTimeCommand
implements CommandExecutor {
    public static CommandSpec create() {
        return CommandSpec.builder().description((Text)Text.of((String)"Sets the rental time for a region")).arguments(new CommandElement[]{RentableRegionsCommand.getRegionElement(), GenericArguments.string((Text)Text.of((String)"time"))}).permission("rentableregions.admin.command.time").executor((CommandExecutor)new AdminTimeCommand()).build();
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Duration time;
        RentedRegion region = (RentedRegion)args.getOne((Text)Text.of((String)"region")).get();
        try {
            time = RentableRegions.parseTime((String)args.getOne((Text)Text.of((String)"time")).get());
        }
        catch (Exception e) {
            throw new CommandException((Text)Text.of((String)"Error parsing time!"), (Throwable)e);
        }
        region.setNewDuration(time);
        src.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Successfully set rental duration of " + region.name + " to " + RentableRegions.formatTime(time)}));
        return CommandResult.success();
    }
}

