/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockHydroponicBase;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityHydroponicFarm;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityHydroponicBase
extends TileBaseElectricBlockWithInventory
implements IFluidHandlerWrapper,
ISidedInventory,
IPacketReceiver {
    public static final int PROCESS_TIME_REQUIRED_BASE = 12000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = 12000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private final int tankCapacity = 3000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank = new FluidTank(this.tankCapacity);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int moduleLevel;
    private static List<SeedData> seeds = new ArrayList<SeedData>();

    public TileEntityHydroponicBase() {
        super("tile.hydroponic_base.name");
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 45.0f);
        this.inventory = NonNullList.func_191197_a((int)20, (Object)ItemStack.field_190927_a);
        this.setTierGC(1);
    }

    public static void addPlant(ItemStack seed, ItemStack product, ItemStack secproduct, int secchance, Block block, int stages, boolean[] rand) {
        if (secproduct == null) {
            secproduct = ItemStack.field_190927_a;
        }
        SeedData data = new SeedData(seed, product, secproduct, secchance, block, stages, rand);
        seeds.add(data);
    }

    public List getSeeds() {
        return seeds;
    }

    public SeedData getData(ItemStack seed) {
        for (SeedData data : seeds) {
            if (!seed.func_77969_a(data.getSeed())) continue;
            return data;
        }
        return null;
    }

    public void func_73660_a() {
        super.func_73660_a();
        this.checkBlock(this.field_145850_b);
        if (!this.field_145850_b.field_72995_K) {
            boolean isWater;
            FluidStack liquid;
            if (!((ItemStack)this.getInventory().get(1)).func_190926_b() && (liquid = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.getInventory().get(1)))) != null && (isWater = FluidRegistry.getFluidName((FluidStack)liquid).startsWith("water")) && (this.waterTank.getFluid() == null || this.waterTank.getFluid().amount + liquid.amount <= this.waterTank.getCapacity())) {
                int amount;
                this.waterTank.fill(new FluidStack(FluidRegistry.WATER, liquid.amount), true);
                ItemStack bucket = (ItemStack)this.getInventory().get(1);
                if (bucket.func_77973_b() != Items.field_151131_as && micdoodle8.mods.galacticraft.core.util.FluidUtil.isBucket((ItemStack)((ItemStack)this.getInventory().get(1))) || micdoodle8.mods.galacticraft.core.util.FluidUtil.isFilledContainer((ItemStack)((ItemStack)this.getInventory().get(1)))) {
                    amount = ((ItemStack)this.getInventory().get(1)).func_190916_E();
                    if (amount > 1) {
                        this.waterTank.fill(new FluidStack(FluidRegistry.WATER, (amount - 1) * 1000), true);
                    } else {
                        IFluidHandlerItem handlerItem = FluidUtil.getFluidHandler((ItemStack)bucket);
                        this.getInventory().set(1, (Object)new ItemStack(handlerItem.getContainer().func_77973_b(), amount));
                    }
                }
                if (bucket.func_77973_b() == Items.field_151131_as) {
                    amount = ((ItemStack)this.getInventory().get(1)).func_190916_E();
                    if (amount > 1) {
                        this.waterTank.fill(new FluidStack(FluidRegistry.WATER, (amount - 1) * 1000), true);
                    }
                    this.getInventory().set(1, (Object)new ItemStack(Items.field_151133_ar, amount));
                } else {
                    ((ItemStack)this.getInventory().get(1)).func_190918_g(1);
                    if (((ItemStack)this.getInventory().get(1)).func_190916_E() == 0) {
                        this.getInventory().set(1, (Object)ItemStack.field_190927_a);
                    }
                }
            }
            if (this.canProcess()) {
                if (this.hasEnoughEnergyToRun) {
                    if (this.processTicks == 0) {
                        this.processTicks = this.processTimeRequired;
                    } else {
                        if (--this.processTicks <= 0) {
                            this.smeltItem();
                            this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                        }
                        this.waterTank.drain(1, true);
                        if (!((ItemStack)this.getInventory().get(8)).func_190926_b() && (((ItemStack)this.getInventory().get(8)).func_77973_b() == Items.field_151100_aR && ((ItemStack)this.getInventory().get(8)).func_77952_i() == 15 || ((ItemStack)this.getInventory().get(8)).func_77973_b() == GSItems.BASIC && ((ItemStack)this.getInventory().get(8)).func_77952_i() == 4) && this.processTicks % 100 == 0) {
                            this.processTicks -= 2000;
                            if (((ItemStack)this.getInventory().get(8)).func_190916_E() > 1) {
                                ((ItemStack)this.getInventory().get(8)).func_190918_g(1);
                            } else {
                                this.getInventory().set(8, (Object)ItemStack.field_190927_a);
                            }
                        }
                    }
                } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    ++this.processTicks;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    public boolean canProcess() {
        if (this.waterTank.getFluidAmount() < 10 * this.getModuleLevel()) {
            return false;
        }
        for (int i = 1; i <= this.getModuleLevel(); ++i) {
            if (!((ItemStack)this.getInventory().get(i * 2 + 1)).func_190926_b() && ((ItemStack)this.getInventory().get(i * 2 + 1)).func_190916_E() >= 64 && !((ItemStack)this.getInventory().get(i + 8)).func_190926_b() && ((ItemStack)this.getInventory().get(i + 8)).func_190916_E() >= 64) {
                return false;
            }
            if (((ItemStack)this.getInventory().get(i * 2)).func_190926_b()) {
                return false;
            }
            ItemStack stack = (ItemStack)this.getInventory().get(i * 2);
            SeedData data = this.getSeedData(stack);
            if (data == null) {
                return false;
            }
            if (((ItemStack)this.getInventory().get(i * 2 + 1)).func_190926_b() || ((ItemStack)this.getInventory().get(i * 2 + 1)).func_77973_b() == data.getProduct(false).func_77973_b()) continue;
            return false;
        }
        return true;
    }

    public void smeltItem() {
        for (int i = 1; i <= this.getModuleLevel(); ++i) {
            if (((ItemStack)this.getInventory().get(i * 2)).func_190926_b()) continue;
            Random rand = new Random();
            SeedData seed = this.getSeedData((ItemStack)this.getInventory().get(i * 2));
            if (seed != null && ((ItemStack)this.getInventory().get(i * 2)).func_77969_a(seed.getSeed())) {
                ItemStack stack;
                if (((ItemStack)this.getInventory().get(i * 2 + 1)).func_190926_b()) {
                    stack = seed.getProduct(false).func_77946_l();
                    stack.func_190920_e(1 + (seed.hasRandCount[0] ? rand.nextInt(3) : 0));
                    this.getInventory().set(i * 2 + 1, (Object)stack);
                } else {
                    ((ItemStack)this.getInventory().get(i * 2 + 1)).func_190917_f(1 + (seed.hasRandCount[0] ? rand.nextInt(3) : 0));
                }
                if (!seed.getProduct(true).func_190926_b() && rand.nextInt(101 - seed.secondchance) == 0) {
                    if (((ItemStack)this.getInventory().get(i + 8)).func_190926_b()) {
                        stack = seed.getProduct(true).func_77946_l();
                        stack.func_190920_e(1 + (seed.hasRandCount[1] ? rand.nextInt(3) : 0));
                        this.getInventory().set(i + 8, (Object)stack);
                    } else {
                        ((ItemStack)this.getInventory().get(i + 8)).func_190917_f(1 + (seed.hasRandCount[1] ? rand.nextInt(3) : 0));
                    }
                }
            }
            if (((ItemStack)this.getInventory().get(i * 2)).func_190916_E() > 1) {
                ((ItemStack)this.getInventory().get(i * 2)).func_190918_g(1);
                continue;
            }
            this.getInventory().set(i * 2, (Object)ItemStack.field_190927_a);
        }
    }

    public void checkBlock(World world) {
        int i;
        boolean[] check = new boolean[4];
        int i2 = 0;
        while (world.func_180495_p(this.field_174879_c.func_177981_b(i2 + 1)).func_177230_c() == GSBlocks.HYDROPONIC_FARM) {
            check[i2] = true;
            ++i2;
        }
        int k = 0;
        for (i = 0; i < 3; ++i) {
            if (!check[i]) continue;
            ++k;
        }
        this.setModuleLevel(k);
        for (i = 1; i <= this.getModuleLevel(); ++i) {
            if (!(world.func_175625_s(this.field_174879_c.func_177981_b(i)) instanceof TileEntityHydroponicFarm)) continue;
            TileEntityHydroponicFarm farm = (TileEntityHydroponicFarm)world.func_175625_s(this.field_174879_c.func_177981_b(i));
            if (farm != null) {
                if (!((ItemStack)this.getInventory().get(i * 2)).func_190926_b()) {
                    SeedData data = this.getSeedData((ItemStack)this.getInventory().get(i * 2));
                    if (data != null) {
                        int scale = this.processTicks > 0 ? (int)((double)this.processTicks / (double)this.processTimeRequired * (double)data.getStages()) : data.getStages();
                        farm.setPlant(data.getBlock());
                        farm.setMetaPlant(data.getStages() - scale);
                        farm.func_70296_d();
                    } else {
                        farm.setPlant(null);
                        farm.setMetaPlant(0);
                        farm.func_70296_d();
                    }
                } else {
                    farm.setPlant(null);
                    farm.setMetaPlant(0);
                    farm.func_70296_d();
                }
            }
            if (i <= this.getModuleLevel() || ((ItemStack)this.getInventory().get(i * 2)).func_190926_b()) continue;
            this.getInventory().set(i * 2, (Object)ItemStack.field_190927_a);
        }
    }

    private SeedData getSeedData(ItemStack stack) {
        for (SeedData seeds : TileEntityHydroponicBase.seeds) {
            if (!seeds.getSeed().func_77969_a(stack)) continue;
            return seeds;
        }
        return null;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_189515_b(nbttagcompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.moduleLevel = par1NBTTagCompound.func_74762_e("moduleTier");
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        ItemStackHelper.func_191283_b((NBTTagCompound)par1NBTTagCompound, (NonNullList)this.getInventory());
        if (par1NBTTagCompound.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        super.func_189515_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        par1NBTTagCompound.func_74768_a("moduleTier", this.moduleLevel);
        ItemStackHelper.func_191282_a((NBTTagCompound)par1NBTTagCompound, (NonNullList)this.getInventory());
        if (this.waterTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
        return par1NBTTagCompound;
    }

    public int getModuleLevel() {
        return this.moduleLevel;
    }

    public void setModuleLevel(int newTier) {
        this.moduleLevel = newTier;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID == 1 || slotID == 3 || slotID == 5 || slotID == 7 || slotID == 9 || slotID == 10 || slotID == 11;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
            }
            case 1: {
                return itemstack.func_77973_b() == Items.field_151131_as;
            }
            case 2: 
            case 4: 
            case 6: {
                return itemstack.func_77973_b() == Items.field_151014_N || itemstack.func_77973_b() == Items.field_151172_bF || itemstack.func_77973_b() == Items.field_151174_bG;
            }
            case 8: {
                return itemstack.func_77973_b() == Items.field_151100_aR && itemstack.func_77952_i() == 15 || itemstack.func_77973_b() == GSItems.BASIC && itemstack.func_77952_i() == 4;
            }
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (this.getPipe().equals((Object)from) && resource != null && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && liquidName.startsWith("water")) {
            used = this.waterTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (from == this.getPipe()) {
            return this.waterTank.getFluid() == null || this.waterTank.getFluidAmount() < this.waterTank.getCapacity();
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockHydroponicBase) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockHydroponicBase.FACING);
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.DOWN;
    }

    private EnumFacing getPipe() {
        return this.getFront().func_176734_d();
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        if (type == NetworkType.FLUID) {
            return direction == this.getPipe();
        }
        return false;
    }

    public int getScaledFluidLevel(int i) {
        return this.waterTank.getFluidAmount() * i / this.waterTank.getCapacity();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    static class SeedData {
        private ItemStack seed;
        private ItemStack product;
        private ItemStack secondproduct;
        private Block block;
        private int stages;
        private int secondchance;
        private boolean[] hasRandCount = new boolean[2];

        public SeedData(ItemStack seed, ItemStack product, ItemStack secondproduct, int secondchance, Block block, int stages, boolean[] rand) {
            this.seed = seed;
            this.product = product;
            this.secondproduct = secondproduct;
            this.secondchance = secondchance;
            this.block = block;
            this.stages = stages;
            this.hasRandCount = rand;
        }

        public ItemStack getSeed() {
            return this.seed;
        }

        public ItemStack getProduct(boolean second) {
            if (second) {
                return this.secondproduct;
            }
            return this.product;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getStages() {
            return this.stages;
        }

        public boolean[] hasRandCount() {
            return this.hasRandCount;
        }
    }
}

