/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.bbcode.render;

import java.util.EnumSet;
import net.malisis.core.client.gui.GuiRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class BBRenderElement {
    public EnumSet<TextFormatting> styles = EnumSet.noneOf(TextFormatting.class);
    public boolean shadow;
    public int color = 0;
    public int bgColor = 0;
    public String text;
    public ItemStack itemStack;
    public int line;
    public boolean newLine = false;

    public BBRenderElement(BBRenderElement element) {
        if (element == null) {
            return;
        }
        this.color = element.color;
        this.bgColor = element.bgColor;
        this.styles.addAll(element.styles);
        this.line = element.line;
    }

    public BBRenderElement split(int position) {
        if (this.text == null) {
            return null;
        }
        if (position < 0 || position > this.text.length()) {
            return null;
        }
        if (position == this.text.length()) {
            this.newLine = true;
            return null;
        }
        BBRenderElement split = new BBRenderElement(this);
        split.text = this.text.substring(position);
        ++split.line;
        this.text = this.text.substring(0, position);
        this.newLine = true;
        return split;
    }

    public String getFormattedText() {
        String str = "";
        for (Object e : this.styles) {
            str = str + e;
        }
        return str + this.text;
    }

    public int width() {
        if (this.itemStack != null) {
            return 16;
        }
        return 0;
    }

    public void render(GuiRenderer renderer, int x, int y, int z) {
        if (this.itemStack != null) {
            renderer.drawItemStack(this.itemStack, x, y);
        } else {
            renderer.drawText(null, this.getFormattedText(), x, y, z, null);
        }
    }

    public String toString() {
        return this.styles.toString() + Integer.toHexString(this.color) + "/" + Integer.toHexString(this.bgColor) + " : " + this.text + (this.newLine ? "~" : "");
    }
}

