/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.configurate;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import me.lucko.luckperms.lib.configurate.objectmapping.DefaultObjectMapperFactory;
import me.lucko.luckperms.lib.configurate.objectmapping.ObjectMapperFactory;
import me.lucko.luckperms.lib.configurate.objectmapping.serialize.TypeSerializerCollection;
import me.lucko.luckperms.lib.configurate.objectmapping.serialize.TypeSerializers;
import me.lucko.luckperms.lib.configurate.util.MapFactories;
import me.lucko.luckperms.lib.configurate.util.MapFactory;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConfigurationOptions {
    private final @NonNull MapFactory mapFactory;
    private final @Nullable String header;
    private final @NonNull TypeSerializerCollection serializers;
    private final @Nullable ImmutableSet<Class<?>> acceptedTypes;
    private final @NonNull ObjectMapperFactory objectMapperFactory;
    private final boolean shouldCopyDefaults;

    private ConfigurationOptions(@NonNull MapFactory mapFactory, @Nullable String header, @NonNull TypeSerializerCollection serializers, @Nullable Set<Class<?>> acceptedTypes, @NonNull ObjectMapperFactory objectMapperFactory, boolean shouldCopyDefaults) {
        this.mapFactory = mapFactory;
        this.header = header;
        this.serializers = serializers;
        this.acceptedTypes = acceptedTypes == null ? null : ImmutableSet.copyOf(acceptedTypes);
        this.objectMapperFactory = objectMapperFactory;
        this.shouldCopyDefaults = shouldCopyDefaults;
    }

    public static @NonNull ConfigurationOptions defaults() {
        return new ConfigurationOptions(MapFactories.insertionOrdered(), null, TypeSerializers.getDefaultSerializers(), null, DefaultObjectMapperFactory.getInstance(), false);
    }

    public @NonNull MapFactory getMapFactory() {
        return this.mapFactory;
    }

    public @NonNull ConfigurationOptions setMapFactory(@NonNull MapFactory mapFactory) {
        Preconditions.checkNotNull((Object)mapFactory, (Object)"mapFactory");
        if (this.mapFactory == mapFactory) {
            return this;
        }
        return new ConfigurationOptions(mapFactory, this.header, this.serializers, (Set<Class<?>>)this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public @Nullable String getHeader() {
        return this.header;
    }

    public @NonNull ConfigurationOptions setHeader(@Nullable String header) {
        if (Objects.equal((Object)this.header, (Object)header)) {
            return this;
        }
        return new ConfigurationOptions(this.mapFactory, header, this.serializers, (Set<Class<?>>)this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public @NonNull TypeSerializerCollection getSerializers() {
        return this.serializers;
    }

    public @NonNull ConfigurationOptions setSerializers(@NonNull TypeSerializerCollection serializers) {
        Preconditions.checkNotNull((Object)serializers, (Object)"serializers");
        if (this.serializers == serializers) {
            return this;
        }
        return new ConfigurationOptions(this.mapFactory, this.header, serializers, (Set<Class<?>>)this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public @NonNull ObjectMapperFactory getObjectMapperFactory() {
        return this.objectMapperFactory;
    }

    public @NonNull ConfigurationOptions setObjectMapperFactory(@NonNull ObjectMapperFactory objectMapperFactory) {
        Preconditions.checkNotNull((Object)objectMapperFactory, (Object)"factory");
        if (this.objectMapperFactory == objectMapperFactory) {
            return this;
        }
        return new ConfigurationOptions(this.mapFactory, this.header, this.serializers, (Set<Class<?>>)this.acceptedTypes, objectMapperFactory, this.shouldCopyDefaults);
    }

    public boolean acceptsType(@NonNull Class<?> type) {
        Preconditions.checkNotNull(type, (Object)"type");
        if (this.acceptedTypes == null) {
            return true;
        }
        if (this.acceptedTypes.contains(type)) {
            return true;
        }
        for (Class clazz : this.acceptedTypes) {
            if (!clazz.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public @NonNull ConfigurationOptions setAcceptedTypes(@Nullable Set<Class<?>> acceptedTypes) {
        if (Objects.equal(this.acceptedTypes, acceptedTypes)) {
            return this;
        }
        return new ConfigurationOptions(this.mapFactory, this.header, this.serializers, acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public boolean shouldCopyDefaults() {
        return this.shouldCopyDefaults;
    }

    public @NonNull ConfigurationOptions setShouldCopyDefaults(boolean shouldCopyDefaults) {
        if (this.shouldCopyDefaults == shouldCopyDefaults) {
            return this;
        }
        return new ConfigurationOptions(this.mapFactory, this.header, this.serializers, (Set<Class<?>>)this.acceptedTypes, this.objectMapperFactory, shouldCopyDefaults);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurationOptions)) {
            return false;
        }
        ConfigurationOptions that = (ConfigurationOptions)o;
        return Objects.equal((Object)this.shouldCopyDefaults, (Object)that.shouldCopyDefaults) && Objects.equal((Object)this.mapFactory, (Object)that.mapFactory) && Objects.equal((Object)this.header, (Object)that.header) && Objects.equal((Object)this.serializers, (Object)that.serializers) && Objects.equal(this.acceptedTypes, that.acceptedTypes) && Objects.equal((Object)this.objectMapperFactory, (Object)that.objectMapperFactory);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mapFactory, this.header, this.serializers, this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults});
    }
}

