/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.compat.jei.altar;

import WayofTime.bloodmagic.api.impl.recipe.RecipeBloodAltar;
import WayofTime.bloodmagic.util.helper.NumeralHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class AltarRecipeJEI
implements IRecipeWrapper {
    @Nonnull
    private final List<ItemStack> input;
    @Nonnull
    private final ItemStack output;
    private final String[] infoString;
    private final int consumptionRate;
    private final int drainRate;

    public AltarRecipeJEI(RecipeBloodAltar recipe) {
        this.input = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])recipe.getInput().func_193365_a());
        this.output = recipe.getOutput();
        this.infoString = new String[]{TextHelper.localize("jei.bloodmagic.recipe.requiredTier", NumeralHelper.toRoman(recipe.getMinimumTier().toInt())), TextHelper.localize("jei.bloodmagic.recipe.requiredLP", recipe.getSyphon())};
        this.consumptionRate = recipe.getConsumeRate();
        this.drainRate = recipe.getDrainRate();
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.input);
        ingredients.setOutput(ItemStack.class, (Object)this.output);
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList tooltip = Lists.newArrayList();
        if (mouseX >= 13 && mouseX <= 64 && mouseY >= 27 && mouseY <= 58) {
            tooltip.add(TextHelper.localize("jei.bloodmagic.recipe.consumptionRate", this.consumptionRate));
            tooltip.add(TextHelper.localize("jei.bloodmagic.recipe.drainRate", this.drainRate));
        }
        return tooltip;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.field_71466_p.func_78276_b(this.infoString[0], 90 - minecraft.field_71466_p.func_78256_a(this.infoString[0]) / 2, 0, Color.gray.getRGB());
        minecraft.field_71466_p.func_78276_b(this.infoString[1], 90 - minecraft.field_71466_p.func_78256_a(this.infoString[1]) / 2, 10, Color.gray.getRGB());
    }
}

