/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.utils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LuaPattern {
    private static final int L_ESC = 37;
    private static final String SPECIALS = "^$*+?.([%-";
    private static final int MAX_CAPTURES = 32;
    private static final int CAP_UNFINISHED = -1;
    private static final int CAP_POSITION = -2;
    private static final byte MASK_ALPHA = 1;
    private static final byte MASK_LOWERCASE = 2;
    private static final byte MASK_UPPERCASE = 4;
    private static final byte MASK_DIGIT = 8;
    private static final byte MASK_PUNCT = 16;
    private static final byte MASK_SPACE = 32;
    private static final byte MASK_CONTROL = 64;
    private static final byte MASK_HEXDIGIT = -128;
    private static final byte[] CHAR_TABLE = new byte[256];

    private LuaPattern() {
    }

    @Nullable
    public static String[] match(@Nonnull String string, @Nonnull String pattern) {
        if (pattern.isEmpty()) {
            return new String[0];
        }
        MatchState ms = new MatchState(string, pattern);
        boolean anchor = false;
        int patternOffset = 0;
        if (pattern.charAt(0) == '^') {
            anchor = true;
            patternOffset = 1;
        }
        int stringOffset = 0;
        do {
            ms.reset();
            int res = ms.match(stringOffset, patternOffset);
            if (res == -1) continue;
            return ms.getCaptures(stringOffset, res);
        } while (stringOffset++ < string.length() && !anchor);
        return null;
    }

    public static boolean matches(@Nonnull String string, @Nonnull String pattern) {
        if (pattern.isEmpty()) {
            return true;
        }
        MatchState ms = new MatchState(string, pattern);
        boolean anchor = false;
        int patternOffset = 0;
        if (pattern.charAt(0) == '^') {
            anchor = true;
            patternOffset = 1;
        }
        int stringOffset = 0;
        do {
            ms.reset();
            if (ms.match(stringOffset, patternOffset) == -1) continue;
            return true;
        } while (stringOffset++ < string.length() && !anchor);
        return false;
    }

    private static boolean matchClass(int character, char matchClass) {
        boolean res;
        byte lcl = (byte)(Character.toLowerCase(matchClass) & 0xFF);
        byte cdata = CHAR_TABLE[character & 0xFF];
        switch (lcl) {
            case 97: {
                res = (cdata & 1) != 0;
                break;
            }
            case 100: {
                res = (cdata & 8) != 0;
                break;
            }
            case 108: {
                res = (cdata & 2) != 0;
                break;
            }
            case 117: {
                res = (cdata & 4) != 0;
                break;
            }
            case 99: {
                res = (cdata & 0x40) != 0;
                break;
            }
            case 112: {
                res = (cdata & 0x10) != 0;
                break;
            }
            case 115: {
                res = (cdata & 0x20) != 0;
                break;
            }
            case 119: {
                res = (cdata & 9) != 0;
                break;
            }
            case 120: {
                res = (cdata & 0xFFFFFF80) != 0;
                break;
            }
            case 122: {
                res = character == 0;
                break;
            }
            default: {
                return matchClass == character;
            }
        }
        return lcl == matchClass == res;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            char c = (char)i;
            LuaPattern.CHAR_TABLE[i] = (byte)((Character.isDigit(c) ? 8 : 0) | (Character.isLowerCase(c) ? 2 : 0) | (Character.isUpperCase(c) ? 4 : 0) | (c < ' ' || c == '\u007f' ? 64 : 0));
            if (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9') {
                int n = i;
                CHAR_TABLE[n] = (byte)(CHAR_TABLE[n] | 0xFFFFFF80);
            }
            if (c >= '!' && c <= '/' || c >= ':' && c <= '@') {
                int n = i;
                CHAR_TABLE[n] = (byte)(CHAR_TABLE[n] | 0x10);
            }
            if ((CHAR_TABLE[i] & 6) == 0) continue;
            int n = i;
            CHAR_TABLE[n] = (byte)(CHAR_TABLE[n] | 1);
        }
        LuaPattern.CHAR_TABLE[32] = 32;
        CHAR_TABLE[13] = (byte)(CHAR_TABLE[13] | 0x20);
        CHAR_TABLE[10] = (byte)(CHAR_TABLE[10] | 0x20);
        CHAR_TABLE[9] = (byte)(CHAR_TABLE[9] | 0x20);
        CHAR_TABLE[11] = (byte)(CHAR_TABLE[11] | 0x20);
        CHAR_TABLE[12] = (byte)(CHAR_TABLE[12] | 0x20);
    }

    private static final class MatchState {
        private final String string;
        private final String pattern;
        private int level;
        private final int[] captureInit = new int[32];
        private final int[] captureLength = new int[32];

        MatchState(String string, String pattern) {
            this.string = string;
            this.pattern = pattern;
            this.level = 0;
        }

        public void reset() {
            this.level = 0;
        }

        String[] getCaptures(int offset, int end) {
            int levels = this.level == 0 ? 1 : this.level;
            String[] v = new String[levels];
            for (int i = 0; i < levels; ++i) {
                v[i] = this.getCapture(i, offset, end);
            }
            return v;
        }

        private String getCapture(int index, int offset, int end) {
            if (index >= this.level) {
                if (index == 0) {
                    return this.string.substring(offset, end);
                }
                throw new IllegalArgumentException("invalid capture index");
            }
            int l = this.captureLength[index];
            if (l == -1) {
                throw new IllegalArgumentException("unfinished capture");
            }
            if (l == -2) {
                return String.valueOf(this.captureInit[index] + 1);
            }
            int begin = this.captureInit[index];
            return this.string.substring(begin, begin + l);
        }

        private int captureToClose() {
            int index = this.level;
            --index;
            while (index >= 0) {
                if (this.captureLength[index] == -1) {
                    return index;
                }
                --index;
            }
            throw new IllegalArgumentException("invalid pattern capture");
        }

        private int classEnd(int patternOffset) {
            switch (this.pattern.charAt(patternOffset++)) {
                case '%': {
                    if (patternOffset == this.pattern.length()) {
                        throw new IllegalArgumentException("malformed pattern (ends with %)");
                    }
                    return patternOffset + 1;
                }
                case '[': {
                    if (this.pattern.charAt(patternOffset) == '^') {
                        ++patternOffset;
                    }
                    do {
                        if (patternOffset == this.pattern.length()) {
                            throw new IllegalArgumentException("malformed pattern (missing ])");
                        }
                        if (this.pattern.charAt(patternOffset++) != '%' || patternOffset == this.pattern.length()) continue;
                        ++patternOffset;
                    } while (this.pattern.charAt(patternOffset) != ']');
                    return patternOffset + 1;
                }
            }
            return patternOffset;
        }

        private boolean matchBracketClass(int character, int patternStart, int patternEnd) {
            boolean sig = true;
            if (this.pattern.charAt(patternStart + 1) == '^') {
                sig = false;
                ++patternStart;
            }
            while (++patternStart < patternEnd) {
                if (!(this.pattern.charAt(patternStart) == '%' ? LuaPattern.matchClass(character, this.pattern.charAt(++patternStart)) : (this.pattern.charAt(patternStart + 1) == '-' && patternStart + 2 < patternEnd ? this.pattern.charAt((patternStart += 2) - 2) <= character && character <= this.pattern.charAt(patternStart) : this.pattern.charAt(patternStart) == character))) continue;
                return sig;
            }
            return !sig;
        }

        private boolean singleMatch(int c, int poff, int ep) {
            switch (this.pattern.charAt(poff)) {
                case '.': {
                    return true;
                }
                case '%': {
                    return LuaPattern.matchClass(c, this.pattern.charAt(poff + 1));
                }
                case '[': {
                    return this.matchBracketClass(c, poff, ep - 1);
                }
            }
            return this.pattern.charAt(poff) == c;
        }

        private int match(int stringOffset, int patternOffset) {
            block16: while (patternOffset != this.pattern.length()) {
                switch (this.pattern.charAt(patternOffset)) {
                    case '(': {
                        if (++patternOffset < this.pattern.length() && this.pattern.charAt(patternOffset) == ')') {
                            return this.startCapture(stringOffset, patternOffset + 1, -2);
                        }
                        return this.startCapture(stringOffset, patternOffset, -1);
                    }
                    case ')': {
                        return this.endCapture(stringOffset, patternOffset + 1);
                    }
                    case '%': {
                        if (patternOffset + 1 == this.pattern.length()) {
                            throw new IllegalArgumentException("malformed pattern (ends with '%')");
                        }
                        switch (this.pattern.charAt(patternOffset + 1)) {
                            case 'b': {
                                stringOffset = this.matchBalance(stringOffset, patternOffset + 2);
                                if (stringOffset == -1) {
                                    return -1;
                                }
                                patternOffset += 4;
                                continue block16;
                            }
                            case 'f': {
                                char previous;
                                if (this.pattern.charAt(patternOffset += 2) != '[') {
                                    throw new IllegalArgumentException("Missing [ after %f in pattern");
                                }
                                int ep = this.classEnd(patternOffset);
                                char c = previous = stringOffset == 0 ? (char)'\u0000' : this.string.charAt(stringOffset - 1);
                                if (this.matchBracketClass(previous, patternOffset, ep - 1) || stringOffset < this.string.length() && !this.matchBracketClass(this.string.charAt(stringOffset), patternOffset, ep - 1)) {
                                    return -1;
                                }
                                patternOffset = ep;
                                continue block16;
                            }
                        }
                        char c = this.pattern.charAt(patternOffset + 1);
                        if (!Character.isDigit(c)) break;
                        if ((stringOffset = this.matchCapture(stringOffset, c)) == -1) {
                            return -1;
                        }
                        return this.match(stringOffset, patternOffset + 2);
                    }
                    case '$': {
                        if (patternOffset + 1 != this.pattern.length()) break;
                        return stringOffset == this.string.length() ? stringOffset : -1;
                    }
                }
                int patternEnd = this.classEnd(patternOffset);
                boolean m = stringOffset < this.string.length() && this.singleMatch(this.string.charAt(stringOffset), patternOffset, patternEnd);
                char patChar = patternEnd < this.pattern.length() ? this.pattern.charAt(patternEnd) : (char)'\u0000';
                switch (patChar) {
                    case '?': {
                        int res;
                        if (m && (res = this.match(stringOffset + 1, patternEnd + 1)) != -1) {
                            return res;
                        }
                        patternOffset = patternEnd + 1;
                        continue block16;
                    }
                    case '*': {
                        return this.maxExpand(stringOffset, patternOffset, patternEnd);
                    }
                    case '+': {
                        return m ? this.maxExpand(stringOffset + 1, patternOffset, patternEnd) : -1;
                    }
                    case '-': {
                        return this.minExpand(stringOffset, patternOffset, patternEnd);
                    }
                }
                if (!m) {
                    return -1;
                }
                ++stringOffset;
                patternOffset = patternEnd;
            }
            return stringOffset;
        }

        private int maxExpand(int stringOffset, int patternOffset, int ep) {
            int i = 0;
            while (stringOffset + i < this.string.length() && this.singleMatch(this.string.charAt(stringOffset + i), patternOffset, ep)) {
                ++i;
            }
            while (i >= 0) {
                int res = this.match(stringOffset + i, ep + 1);
                if (res != -1) {
                    return res;
                }
                --i;
            }
            return -1;
        }

        private int minExpand(int stringOffset, int patternOffset, int ep) {
            while (true) {
                int res;
                if ((res = this.match(stringOffset, ep + 1)) != -1) {
                    return res;
                }
                if (stringOffset >= this.string.length() || !this.singleMatch(this.string.charAt(stringOffset), patternOffset, ep)) break;
                ++stringOffset;
            }
            return -1;
        }

        private int startCapture(int stringOffset, int patternOffset, int what) {
            int level = this.level;
            if (level >= 32) {
                throw new IllegalArgumentException("too many captures");
            }
            this.captureInit[level] = stringOffset;
            this.captureLength[level] = what;
            this.level = level + 1;
            int res = this.match(stringOffset, patternOffset);
            if (res == -1) {
                --this.level;
            }
            return res;
        }

        private int endCapture(int stringOffset, int patternOffset) {
            int level = this.captureToClose();
            this.captureLength[level] = stringOffset - this.captureInit[level];
            int res = this.match(stringOffset, patternOffset);
            if (res == -1) {
                this.captureLength[level] = -1;
            }
            return res;
        }

        private int matchCapture(int stringOffset, int index) {
            if ((index -= 49) < 0 || index >= this.level || this.captureLength[index] == -1) {
                throw new IllegalArgumentException("invalid capture index %" + index);
            }
            int len = this.captureLength[index];
            if (this.string.length() - stringOffset >= len && MatchState.equals(this.string, this.captureInit[index], this.string, stringOffset, len)) {
                return stringOffset + len;
            }
            return -1;
        }

        private static boolean equals(String a, int startA, String b, int startB, int length) {
            return a.substring(startA, startA + length - 1).equals(b.substring(startB, startB + length - 1));
        }

        private int matchBalance(int stringOffset, int patternOffset) {
            int patternLen = this.pattern.length();
            if (patternOffset == patternLen || patternOffset + 1 == patternLen) {
                throw new IllegalArgumentException("unbalanced pattern");
            }
            if (stringOffset >= this.string.length() || this.string.charAt(stringOffset) != this.pattern.charAt(patternOffset)) {
                return -1;
            }
            char begin = this.pattern.charAt(patternOffset);
            char end = this.pattern.charAt(patternOffset + 1);
            int count = 1;
            while (++stringOffset < this.string.length()) {
                if (this.string.charAt(stringOffset) == end) {
                    if (--count != 0) continue;
                    return stringOffset + 1;
                }
                if (this.string.charAt(stringOffset) != begin) continue;
                ++count;
            }
            return -1;
        }
    }
}

