/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.jei;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.PocketUpgrades;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.utils.Helpers;

public abstract class UseInRecipeWrapper
implements IRecipeWrapper {
    private static final String MINECART_COMPUTER = "entity.plethora.plethora:minecartComputer.name";
    protected final ItemStack stack;
    private final IDrawable slotDrawable;
    private final List<String> usable = new ArrayList<String>();
    private final String id;

    public UseInRecipeWrapper(@Nonnull ItemStack stack, String id, @Nonnull ItemStack[] useIn, @Nonnull IGuiHelper helper) {
        this.stack = stack;
        this.slotDrawable = helper.getSlotDrawable();
        this.id = id;
        for (ItemStack use : useIn) {
            this.usable.add(use.func_82833_r());
        }
        if (stack.hasCapability(Constants.VEHICLE_UPGRADE_HANDLER_CAPABILITY, null)) {
            this.usable.add(Helpers.translateToLocal(MINECART_COMPUTER));
        }
        if (PocketUpgrades.get((ItemStack)stack) != null) {
            this.usable.add(new ItemStack((Item)ComputerCraft.Items.pocketComputer).func_82833_r());
        }
        if (PocketUpgrades.get((ItemStack)stack) != null) {
            this.usable.add(new ItemStack((Block)ComputerCraft.Blocks.turtle).func_82833_r());
        }
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)this.stack);
    }

    public abstract boolean isValid();

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int xPos = (recipeWidth - this.slotDrawable.getWidth()) / 2;
        int yPos = 0;
        this.slotDrawable.draw(minecraft, xPos, yPos);
        xPos = 0;
        int color = Color.gray.getRGB();
        minecraft.field_71466_p.func_78276_b(Translator.translateToLocal((String)("gui.jei.plethora." + this.id + ".usable")), xPos, yPos += this.slotDrawable.getHeight() + 4, color);
        yPos += minecraft.field_71466_p.field_78288_b;
        for (String name : this.usable) {
            minecraft.field_71466_p.func_78276_b(" - " + name, xPos, yPos, color);
            yPos += minecraft.field_71466_p.field_78288_b;
        }
    }
}

