/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.meta.ItemStackContextMetaProvider;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.utils.Helpers;

public abstract class ItemEntityStorageMetaProvider<T extends Item>
extends ItemStackContextMetaProvider<T> {
    private final String id;

    protected ItemEntityStorageMetaProvider(String id, Class<T> type, int priority, String description) {
        super(type, priority, description);
        this.id = id;
    }

    protected ItemEntityStorageMetaProvider(String id, Class<T> type, String description) {
        super(type, description);
        this.id = id;
    }

    @Override
    @Nonnull
    public final Map<String, ?> getMeta(@Nonnull IPartialContext<ItemStack> context, @Nonnull T item) {
        Entity entity;
        IWorldLocation location = context.getContext("origin", IWorldLocation.class);
        if (location != null && (entity = this.spawn(context.getTarget(), item, location)) != null) {
            Vec3d pos = location.getLoc();
            entity.func_70080_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0f, 0.0f);
            return Collections.singletonMap(this.id, context.makePartialChild(entity).getMeta());
        }
        Map<String, ?> basic = this.getBasicDetails(context.getTarget(), item);
        return basic.isEmpty() ? Collections.emptyMap() : Collections.singletonMap(this.id, basic);
    }

    @Nullable
    protected abstract Entity spawn(@Nonnull ItemStack var1, @Nonnull T var2, @Nonnull IWorldLocation var3);

    @Nonnull
    protected abstract Map<String, ?> getBasicDetails(@Nonnull ItemStack var1, @Nonnull T var2);

    @Nonnull
    public static Map<String, ?> getBasicDetails(@Nullable NBTTagCompound entityData) {
        if (entityData == null || !entityData.func_150297_b("id", 8)) {
            return Collections.emptyMap();
        }
        return ItemEntityStorageMetaProvider.getBasicDetails(new ResourceLocation(entityData.func_74779_i("id")), entityData);
    }

    @Nonnull
    protected static Map<String, ?> getBasicDetails(@Nonnull ResourceLocation id, @Nullable NBTTagCompound entityData) {
        return ItemEntityStorageMetaProvider.getBasicDetails(id, entityData != null && entityData.func_150297_b("CustomName", 8) ? entityData.func_74779_i("CustomName") : null);
    }

    @Nonnull
    protected static Map<String, ?> getBasicDetails(@Nonnull ResourceLocation id, @Nullable String displayName) {
        String translationKey = EntityList.func_191302_a((ResourceLocation)id);
        if (translationKey == null) {
            return Collections.emptyMap();
        }
        String translated = Helpers.translateToLocal("entity." + translationKey + ".name");
        HashMap<String, String> details = new HashMap<String, String>(2);
        details.put("name", translated);
        details.put("displayName", Strings.isNullOrEmpty((String)displayName) ? translated : displayName);
        return details;
    }
}

