/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.methods;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import net.minecraft.item.Item;
import net.minecraft.util.math.Vec3d;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.TypedLuaObject;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasServer;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ObjectGroup;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object3d.Box;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object3d.Item3D;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object3d.Line3D;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object3d.ObjectFrame;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object3d.ObjectRoot3D;

public final class MethodsCanvas3D {
    private MethodsCanvas3D() {
    }

    @PlethoraMethod(doc="-- Create a new 3D canvas centred relative to the current position.", worldThread=false)
    public static TypedLuaObject<ObjectRoot3D> create(IContext<ObjectGroup.Origin3D> baked, @FromContext CanvasServer canvas, @FromContext(value={"origin"}) IWorldLocation location, @Optional Vec3d offset) {
        if (offset == null) {
            offset = Vec3d.field_186680_a;
        }
        ObjectGroup.Origin3D group = (ObjectGroup.Origin3D)baked.getTarget();
        ObjectRoot3D root = new ObjectRoot3D(canvas.newObjectId(), group.id());
        root.recentre(location.getWorld(), location.getLoc().func_178787_e(offset));
        canvas.add(root);
        return baked.makeChild(root, canvas.reference(root)).getObject();
    }

    @PlethoraMethod(doc="-- Create a new frame to put 2d objects in.", worldThread=false)
    public static TypedLuaObject<ObjectFrame> addFrame(IContext<ObjectGroup.Group3D> baked, @FromContext CanvasServer canvas, Vec3d position) {
        ObjectGroup.Group3D group = (ObjectGroup.Group3D)baked.getTarget();
        ObjectFrame frame = new ObjectFrame(canvas.newObjectId(), group.id());
        frame.setPosition(position);
        canvas.add(frame);
        return baked.makeChild(frame, canvas.reference(frame)).getObject();
    }

    @PlethoraMethod(worldThread=false, doc="function(x:number, y:number, z:number[, width:number, height:number, depth:number][, color:number]):table -- Create a new box.")
    public static TypedLuaObject<Box> addBox(IContext<ObjectGroup.Group3D> baked, @FromContext CanvasServer canvas, Object[] args) throws LuaException {
        int colour;
        double depth;
        double height;
        double width;
        double x = org.squiddev.plethora.api.method.ArgumentHelper.getFloat(args, 0);
        double y = org.squiddev.plethora.api.method.ArgumentHelper.getFloat(args, 1);
        double z = org.squiddev.plethora.api.method.ArgumentHelper.getFloat(args, 2);
        if (args.length <= 4) {
            width = 1.0;
            height = 1.0;
            depth = 1.0;
            colour = ArgumentHelper.optInt((Object[])args, (int)3, (int)-1);
        } else {
            width = org.squiddev.plethora.api.method.ArgumentHelper.getFloat(args, 3);
            height = org.squiddev.plethora.api.method.ArgumentHelper.getFloat(args, 4);
            depth = org.squiddev.plethora.api.method.ArgumentHelper.getFloat(args, 5);
            colour = ArgumentHelper.optInt((Object[])args, (int)6, (int)-1);
        }
        ObjectGroup.Group3D group = (ObjectGroup.Group3D)baked.getTarget();
        Box box = new Box(canvas.newObjectId(), group.id());
        box.setPosition(new Vec3d(x, y, z));
        box.setSize(width, height, depth);
        box.setColour(colour);
        canvas.add(box);
        return baked.makeChild(box, canvas.reference(box)).getObject();
    }

    @PlethoraMethod(doc="-- Create a new line.", worldThread=false)
    public static TypedLuaObject<Line3D> addLine(IContext<ObjectGroup.Group3D> baked, @FromContext CanvasServer canvas, Vec3d start, Vec3d end, @Optional(defDoub=1.0) float thickness, @Optional(defInt=-1) int colour) {
        ObjectGroup.Group3D group = (ObjectGroup.Group3D)baked.getTarget();
        Line3D line = new Line3D(canvas.newObjectId(), group.id());
        line.setVertex(0, start);
        line.setVertex(1, end);
        line.setScale(thickness);
        line.setColour(colour);
        canvas.add(line);
        return baked.makeChild(line, canvas.reference(line)).getObject();
    }

    @PlethoraMethod(doc="-- Create a item model.", worldThread=false)
    public static TypedLuaObject<Item3D> addItem(IContext<ObjectGroup.Group3D> baked, @FromContext CanvasServer canvas, Vec3d position, Item item, @Optional(defInt=0) int damage, @Optional(defDoub=1.0) float scale) {
        ObjectGroup.Group3D group = (ObjectGroup.Group3D)baked.getTarget();
        Item3D model = new Item3D(canvas.newObjectId(), group.id());
        model.setPosition(position);
        model.setScale(scale);
        model.setItem(item);
        model.setDamage(damage);
        canvas.add(model);
        return baked.makeChild(model, canvas.reference(model)).getObject();
    }
}

