/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.client.gui;

import dan200.computercraft.client.gui.widgets.WidgetTerminal;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.IComputer;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.squiddev.plethora.gameplay.keyboard.ContainerKeyboard;
import org.squiddev.plethora.gameplay.neural.ItemComputerHandler;
import org.squiddev.plethora.gameplay.neural.NeuralHelpers;
import org.squiddev.plethora.gameplay.registry.Registration;
import org.squiddev.plethora.utils.Helpers;

@SideOnly(value=Side.CLIENT)
public class GuiKeyboard
extends GuiScreen {
    private final ContainerKeyboard container;
    private final IComputer computer;
    private WidgetTerminal terminalGui;
    private final MouseHandler glassesMouse;

    public GuiKeyboard(IComputer computer) {
        this.computer = computer;
        this.container = new ContainerKeyboard(computer);
        this.glassesMouse = new MouseHandler("glasses", 512, 288);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146297_k.field_71439_g.field_71070_bA = this.container;
        this.terminalGui = new WidgetTerminal(0, 0, 1, 1, () -> this.computer, 2, 2, 2, 2);
        this.terminalGui.setAllowFocusLoss(false);
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.terminalGui.update();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            super.func_73869_a(typedChar, keyCode);
        } else {
            this.keyHandled |= this.terminalGui.onKeyTyped(typedChar, keyCode);
        }
    }

    public void func_146282_l() throws IOException {
        super.func_146282_l();
        this.keyHandled |= this.terminalGui.onKeyboardInput();
    }

    private boolean canInputGlasses() {
        ItemStack neural = NeuralHelpers.getStack((EntityLivingBase)this.field_146297_k.field_71439_g);
        if (neural.func_190926_b()) {
            return false;
        }
        ClientComputer computer = ItemComputerHandler.getClient(neural);
        if (computer != this.computer) {
            return false;
        }
        IItemHandler handler = (IItemHandler)neural.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler == null) {
            return false;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack module = handler.getStackInSlot(i);
            if (module.func_77973_b() != Registration.itemModule || module.func_77960_j() != 6) continue;
            return true;
        }
        return false;
    }

    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (button < 0 || button > 2) {
            return;
        }
        if (this.canInputGlasses()) {
            this.glassesMouse.click(mouseX, mouseY, button);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int wheelChange = Mouse.getEventDWheel();
        if (this.canInputGlasses()) {
            this.glassesMouse.update(mouseX, mouseY, wheelChange);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
        this.func_73732_a(renderer, Helpers.translateToLocal("item.plethora.keyboard.close"), this.field_146294_l / 2, 10, 0xFFFFFF);
    }

    private class MouseHandler {
        private final String prefix;
        private int termWidth;
        private int termHeight;
        private int lastButton = -1;
        private int lastX = -1;
        private int lastY = -1;

        MouseHandler(String prefix, int width, int height) {
            this.prefix = prefix;
            this.termWidth = width;
            this.termHeight = height;
        }

        void setSize(int width, int height) {
            this.termWidth = width;
            this.termHeight = height;
        }

        void click(int x, int y, int button) {
            if (button < 0 || button > 2) {
                return;
            }
            int charX = x * this.termWidth / GuiKeyboard.this.field_146294_l;
            int charY = y * this.termHeight / GuiKeyboard.this.field_146295_m;
            charX = Math.min(Math.max(charX, 0), 511);
            charY = Math.min(Math.max(charY, 0), 287);
            GuiKeyboard.this.computer.queueEvent(this.prefix + "_click", new Object[]{button + 1, charX + 1, charY + 1});
            this.lastButton = button;
            this.lastX = charX;
            this.lastY = charY;
        }

        public void update(int x, int y, int wheelChange) {
            int charX = x * this.termWidth / GuiKeyboard.this.field_146294_l;
            int charY = y * this.termHeight / GuiKeyboard.this.field_146295_m;
            charX = Math.min(Math.max(charX, 0), 511);
            charY = Math.min(Math.max(charY, 0), 287);
            if (this.lastButton >= 0 && !Mouse.isButtonDown((int)this.lastButton)) {
                GuiKeyboard.this.computer.queueEvent(this.prefix + "_up", new Object[]{this.lastButton + 1, charX + 1, charY + 1});
                this.lastButton = -1;
            }
            if (wheelChange < 0) {
                GuiKeyboard.this.computer.queueEvent(this.prefix + "_scroll", new Object[]{1, charX + 1, charY + 1});
            } else if (wheelChange > 0) {
                GuiKeyboard.this.computer.queueEvent(this.prefix + "_scroll", new Object[]{-1, charX + 1, charY + 1});
            }
            if (this.lastButton >= 0 && (charX != this.lastX || charY != this.lastY)) {
                GuiKeyboard.this.computer.queueEvent(this.prefix + "_drag", new Object[]{this.lastButton + 1, charX + 1, charY + 1});
                this.lastX = charX;
                this.lastY = charY;
            }
        }
    }
}

