/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core.executor;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IWorkMonitor;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.squiddev.plethora.api.method.IResultExecutor;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.core.executor.Task;
import org.squiddev.plethora.core.executor.TaskRunner;

public class ComputerAccessExecutor
implements IResultExecutor {
    private static final String EVENT_NAME = "plethora_task";
    private final IComputerAccess access;
    private final String attachmentName;
    private final TaskRunner runner;
    private volatile boolean attached;

    public ComputerAccessExecutor(IComputerAccess access, TaskRunner runner) {
        this.access = access;
        this.attachmentName = access.getAttachmentName();
        this.runner = runner;
    }

    @Override
    @Nullable
    public Object[] execute(@Nonnull MethodResult result, @Nonnull ILuaContext context) throws LuaException, InterruptedException {
        Object[] response;
        this.assertAttached();
        if (result.isFinal()) {
            return result.getResult();
        }
        ComputerTask task = new ComputerTask(this, result.getCallback(), result.getResolver(), true);
        boolean ok = this.runner.submit(task);
        if (!ok) {
            throw new LuaException("Task limit exceeded");
        }
        do {
            response = context.pullEvent(null);
            this.assertAttached();
        } while (response.length < 1 || !EVENT_NAME.equals(response[0]) || !task.isDone());
        if (task.error != null) {
            throw task.error;
        }
        return task.result;
    }

    @Override
    public void executeAsync(@Nonnull MethodResult result) throws LuaException {
        this.assertAttached();
        if (result.isFinal()) {
            return;
        }
        ComputerTask task = new ComputerTask(this, result.getCallback(), result.getResolver(), false);
        boolean ok = this.runner.submit(task);
        if (!ok) {
            task.cancel();
            throw new LuaException("Task limit exceeded");
        }
    }

    private void assertAttached() throws LuaException {
        if (!this.attached) {
            throw new LuaException("Peripheral '" + this.attachmentName + "' is no longer attached");
        }
    }

    public void attach() {
        this.attached = true;
    }

    public void detach() {
        this.attached = false;
    }

    private static class ComputerTask
    extends Task {
        private final IWorkMonitor monitor;
        private final ComputerAccessExecutor executor;
        private final boolean shouldQueue;

        ComputerTask(ComputerAccessExecutor executor, Callable<MethodResult> callback, MethodResult.Resolver resolver, boolean shouldQueue) {
            super(callback, resolver);
            this.executor = executor;
            this.shouldQueue = shouldQueue;
            this.monitor = executor.access.getMainThreadMonitor();
        }

        @Override
        void whenDone() {
            super.whenDone();
            if (!this.executor.attached || !this.shouldQueue) {
                return;
            }
            try {
                this.executor.access.queueEvent(ComputerAccessExecutor.EVENT_NAME, null);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        @Override
        boolean canWork() {
            return this.monitor == null || this.monitor.shouldWork();
        }

        @Override
        protected void submitTiming(long time) {
            super.submitTiming(time);
            this.monitor.trackWork(time, TimeUnit.NANOSECONDS);
        }

        @Override
        public boolean update() {
            if (!this.executor.attached) {
                this.cancel();
                return true;
            }
            return super.update();
        }
    }
}

