/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.wind.misc;

import ic2.api.classic.wind.IWindStream;
import ic2.core.platform.wind.misc.RealisticWindCalculation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;

public class RealisticWindProperty
implements IWindStream {
    boolean rain;
    boolean storm;
    double speed;
    float rotation;
    int yLevel;
    int thickness;
    int maxTimeLeft;
    int ticker;
    private RealisticWindCalculation newValues;

    public RealisticWindProperty(World world) {
        this.newValues = new RealisticWindCalculation(world);
        this.newValues.applyDifference(this);
    }

    public void onTick(World world) {
        ++this.ticker;
        if (this.newValues != null && this.newValues.apply(this)) {
            this.newValues = null;
        }
        if (this.maxTimeLeft-- > 0 && this.validateWorld(world)) {
            return;
        }
        this.newValues = new RealisticWindCalculation(world, this.speed, this.rotation);
        this.newValues.applyDifference(this);
    }

    private boolean validateWorld(World world) {
        if (this.ticker % 20 == 0) {
            WorldInfo info = world.func_72912_H();
            return info.func_76059_o() == this.rain && info.func_76061_m() == this.storm;
        }
        return true;
    }

    public float getRotation() {
        return this.rotation;
    }

    public double getSpeed() {
        return this.speed;
    }

    public boolean isInRange(int y) {
        int myY = this.yLevel + this.thickness;
        int distance = myY > y ? myY - y : y - myY;
        return distance <= 5;
    }

    public double getRangeEffect(int y) {
        int myY = this.yLevel + this.thickness;
        double distance = myY > y ? (double)(myY - y) : (double)(y - myY);
        return distance / 4.0;
    }

    @Override
    public boolean isAxisSupported(EnumFacing.Axis axis) {
        return axis == EnumFacing.Axis.Y;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return new AxisAlignedBB(0.0, (double)this.yLevel, 0.0, 0.0, (double)(this.yLevel + this.thickness), 0.0);
    }

    @Override
    public boolean hasDirection() {
        return true;
    }

    @Override
    public float getDirection() {
        return this.rotation;
    }

    @Override
    public boolean hasAngle() {
        return false;
    }

    @Override
    public float getAngle() {
        return 0.0f;
    }

    @Override
    public double getWindSpeed() {
        return this.speed;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Wind Stream_");
        builder.append("BoundingBox: " + this.getBoundingBox() + "_");
        builder.append("Direction: " + this.rotation + "_");
        builder.append("Speed: " + this.speed);
        return builder.toString();
    }
}

