/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.recipe;

import com.google.common.base.Objects;
import ic2.api.classic.recipe.custom.IClassicScrapBoxManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.MachineRecipe;
import ic2.api.recipe.MachineRecipeResult;
import ic2.api.recipe.RecipeOutput;
import ic2.core.IC2;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ScrapBoxManager
implements IClassicScrapBoxManager {
    public float maxChance;
    Set<IClassicScrapBoxManager.IDrop> drops = new LinkedHashSet<IClassicScrapBoxManager.IDrop>();
    Map<ItemStack, Float> cache = new LinkedHashMap<ItemStack, Float>();

    @Override
    public void addDrop(ItemStack drop, float rawChance) {
        if (drop.func_190926_b() || (double)rawChance <= 0.0) {
            return;
        }
        this.drops.add(new Drop(drop, rawChance));
        this.maxChance += rawChance;
        this.updateRealChance();
    }

    @Override
    public void removeDrop(IClassicScrapBoxManager.IDrop drop) {
        if (drop == null) {
            return;
        }
        this.drops.remove(drop);
        this.maxChance = 0.0f;
        for (IClassicScrapBoxManager.IDrop theDrop : this.drops) {
            this.maxChance += theDrop.getRawChance();
        }
        this.updateRealChance();
    }

    private void updateRealChance() {
        for (IClassicScrapBoxManager.IDrop theDrop : this.drops) {
            Drop drop = (Drop)theDrop;
            drop.setRealChance(drop.getRawChance() / this.maxChance);
        }
    }

    @Override
    public ItemStack getDrop(ItemStack input, boolean adjustInput) {
        if (input.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (adjustInput) {
            input.func_190918_g(1);
        }
        float currentChance = IC2.random.nextFloat() * this.maxChance;
        for (IClassicScrapBoxManager.IDrop drop : this.drops) {
            if (currentChance > drop.getRawChance()) {
                currentChance -= drop.getRawChance();
                continue;
            }
            return drop.getDrop().func_77946_l();
        }
        return null;
    }

    @Override
    public IClassicScrapBoxManager.IDrop getRandomDrop(ItemStack stack, boolean consume) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (consume) {
            stack.func_190918_g(1);
        }
        float currentChance = IC2.random.nextFloat() * this.maxChance;
        for (IClassicScrapBoxManager.IDrop drop : this.drops) {
            if (currentChance > drop.getRawChance()) {
                currentChance -= drop.getRawChance();
                continue;
            }
            return drop;
        }
        return null;
    }

    @Override
    public Map<ItemStack, Float> getDrops() {
        if (this.drops.size() != this.cache.size()) {
            this.cache = new LinkedHashMap<ItemStack, Float>(this.drops.size());
            for (IClassicScrapBoxManager.IDrop drop : this.drops) {
                this.cache.put(drop.getDrop(), Float.valueOf(drop.getRawChance() / this.maxChance));
            }
        }
        return this.cache;
    }

    @Override
    public List<IClassicScrapBoxManager.IDrop> getEntries() {
        return new ArrayList<IClassicScrapBoxManager.IDrop>(this.drops);
    }

    @Override
    public boolean addRecipe(IRecipeInput input, NBTTagCompound metadata, boolean replace, ItemStack ... outputs) {
        return false;
    }

    @Override
    public RecipeOutput getOutputFor(ItemStack input, boolean adjustInput) {
        return null;
    }

    @Override
    public boolean addRecipe(IRecipeInput input, Collection<ItemStack> output, NBTTagCompound metadata, boolean replace) {
        return false;
    }

    @Override
    public MachineRecipeResult<IRecipeInput, Collection<ItemStack>, ItemStack> apply(ItemStack input, boolean acceptTest) {
        return null;
    }

    @Override
    public Iterable<? extends MachineRecipe<IRecipeInput, Collection<ItemStack>>> getRecipes() {
        return new ArrayList();
    }

    @Override
    public boolean isIterable() {
        return false;
    }

    public static class Drop
    implements IClassicScrapBoxManager.IDrop {
        ItemStack drop;
        float rawChance;
        float realChance;
        final int hashCode;

        public Drop(ItemStack item, float dropChance) {
            this.drop = item;
            this.rawChance = dropChance;
            this.hashCode = Objects.hashCode((Object[])new Object[]{this.drop.func_77973_b(), this.drop.func_77960_j(), Float.valueOf(this.rawChance)});
        }

        public void setRealChance(float realChance) {
            this.realChance = realChance;
        }

        @Override
        public float getChance() {
            return this.realChance;
        }

        @Override
        public ItemStack getDrop() {
            return this.drop.func_77946_l();
        }

        @Override
        public float getRawChance() {
            return this.rawChance;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            IClassicScrapBoxManager.IDrop other;
            return obj instanceof IClassicScrapBoxManager.IDrop && StackUtil.isStackEqual(this.drop, (other = (IClassicScrapBoxManager.IDrop)obj).getDrop()) && this.rawChance == other.getRawChance();
        }
    }
}

