/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.classic.recipe;

import net.minecraft.nbt.NBTTagCompound;

public class RecipeModifierHelpers {

    public static class RecipeModifierDouble
    implements IRecipeModifier {
        ModifierType type;
        double amount;

        public RecipeModifierDouble(ModifierType type, double amount) {
            this.type = type;
            this.amount = amount;
        }

        @Override
        public void apply(NBTTagCompound compound) {
            compound.func_74780_a(this.type.doubleEffect, this.amount);
        }
    }

    public static class RecipeModifierInt
    implements IRecipeModifier {
        ModifierType type;
        int amount;

        public RecipeModifierInt(ModifierType type, int amount) {
            this.type = type;
            this.amount = amount;
        }

        @Override
        public void apply(NBTTagCompound compound) {
            compound.func_74768_a(this.type.intEffect, this.amount);
        }
    }

    public static interface IRecipeModifier {
        public void apply(NBTTagCompound var1);
    }

    public static enum ModifierType {
        RECIPE_LENGTH("RecipeTime", "RecipeTimeModifier"),
        RECIPE_ENERGY("RecipeEnergy", "RecipeEnergyModifier");

        String intEffect;
        String doubleEffect;

        private ModifierType(String intEffect, String doubleEffect) {
            this.intEffect = intEffect;
            this.doubleEffect = doubleEffect;
        }

        public RecipeModifierDouble create(double amount) {
            return new RecipeModifierDouble(this, amount);
        }

        public RecipeModifierInt create(int amount) {
            return new RecipeModifierInt(this, amount);
        }
    }
}

