/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.storage;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pregenerator.impl.storage.GlobalListeners;
import pregenerator.impl.storage.INotifyListener;
import pregenerator.impl.storage.MassCircleTask;
import pregenerator.impl.storage.PregenTask;

public class TaskStorage
extends WorldSavedData {
    Set<PregenTask> commandsToRun = new LinkedHashSet<PregenTask>();
    Set<INotifyListener> autoListeners = new LinkedHashSet<INotifyListener>();
    boolean created = false;
    Set<Integer> alreadyRan = new HashSet<Integer>();

    public TaskStorage(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int i;
        this.alreadyRan.clear();
        this.created = nbt.func_74767_n("Created");
        this.commandsToRun.clear();
        this.autoListeners.clear();
        NBTTagList list = nbt.func_150295_c("SavedData", 11);
        for (i = 0; i < list.func_74745_c(); ++i) {
            int[] array = list.func_150306_c(i);
            if (array.length == 10) {
                this.commandsToRun.add(new MassCircleTask(array));
                continue;
            }
            if (array.length != 7) continue;
            this.commandsToRun.add(new PregenTask(array));
        }
        list = nbt.func_150295_c("AutoListeners", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            INotifyListener listener = TaskStorage.fromNBT(list.func_150305_b(i));
            if (listener == null) continue;
            this.autoListeners.add(listener);
        }
        for (int data : nbt.func_74759_k("DimCreated")) {
            this.alreadyRan.add(data);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74757_a("Created", this.created);
        NBTTagList list = new NBTTagList();
        for (PregenTask command : this.commandsToRun) {
            list.func_74742_a((NBTBase)command.save());
        }
        compound.func_74782_a("SavedData", (NBTBase)list);
        list = new NBTTagList();
        for (INotifyListener listener : this.autoListeners) {
            list.func_74742_a((NBTBase)listener.save());
        }
        compound.func_74782_a("AutoListeners", (NBTBase)list);
        int[] dims = new int[this.alreadyRan.size()];
        int index = 0;
        for (Integer data : this.alreadyRan) {
            dims[index] = data;
            ++index;
        }
        compound.func_74783_a("DimCreated", dims);
        return compound;
    }

    public void setCreated() {
        this.created = true;
        this.func_76185_a();
    }

    public boolean isCreated() {
        return this.created;
    }

    public boolean hasNotRanAlready(int dimID) {
        return this.alreadyRan.add(dimID);
    }

    public void savePregenTask(PregenTask command) {
        this.commandsToRun.add(command);
        this.func_76185_a();
    }

    public void savePregenTasks(List<PregenTask> list) {
        this.commandsToRun.addAll(list);
        this.func_76185_a();
    }

    public List<PregenTask> getTasks() {
        return new ArrayList<PregenTask>(this.commandsToRun);
    }

    public void finishTask(PregenTask command) {
        if (this.commandsToRun.remove(command)) {
            this.func_76185_a();
        }
    }

    public void clearAll() {
        this.commandsToRun.clear();
        this.func_76185_a();
    }

    public PregenTask clearOne() {
        Iterator<PregenTask> com = this.commandsToRun.iterator();
        if (com.hasNext()) {
            PregenTask result = com.next();
            com.remove();
            this.func_76185_a();
            return result;
        }
        return null;
    }

    public int clearLast() {
        return this.clearIndex(this.commandsToRun.size());
    }

    public int clearIndex(int index) {
        int done;
        if (index == 0) {
            return this.clearOne() != null ? 2 : 0;
        }
        Iterator<PregenTask> com = this.commandsToRun.iterator();
        for (done = 0; com.hasNext() && done < index; ++done) {
            PregenTask pregenTask = com.next();
        }
        if (done == index) {
            com.remove();
            this.func_76185_a();
            return 1;
        }
        return 0;
    }

    public boolean hasTasks() {
        return this.commandsToRun.size() > 0;
    }

    public int getTaskCount() {
        return this.commandsToRun.size();
    }

    public PregenTask getNextTask() {
        return this.commandsToRun.iterator().next();
    }

    public static TaskStorage getStorage() {
        return TaskStorage.getFromServer(FMLCommonHandler.instance().getMinecraftServerInstance());
    }

    public static TaskStorage getFromServer(MinecraftServer server) {
        return TaskStorage.getFromWorld(server.func_130014_f_());
    }

    public static TaskStorage getFromWorld(World world) {
        TaskStorage storage = (TaskStorage)world.func_72943_a(TaskStorage.class, "PregenTaskStorage");
        if (storage == null) {
            storage = new TaskStorage("PregenTaskStorage");
            world.func_72823_a("PregenTaskStorage", (WorldSavedData)storage);
        }
        return storage;
    }

    public String toString() {
        return this.commandsToRun.toString();
    }

    public void addListenState(ICommandSender sender, boolean state) {
        INotifyListener notitfy = TaskStorage.fromSender(sender, state);
        this.autoListeners.remove(notitfy);
        this.autoListeners.add(notitfy);
    }

    public void removeSender(ICommandSender sender) {
        this.autoListeners.remove(TaskStorage.fromSender(sender, false));
    }

    public int getState(ICommandSender sender) {
        for (INotifyListener listen : this.autoListeners) {
            if (!listen.matches(sender)) continue;
            return listen.isListening() ? 1 : 2;
        }
        return 0;
    }

    public boolean autoListens(ICommandSender sender) {
        for (INotifyListener listen : this.autoListeners) {
            if (!listen.matches(sender)) continue;
            return listen.isListening();
        }
        return true;
    }

    public void addListeners(GlobalListeners listen, MinecraftServer server) {
        for (INotifyListener listener : this.autoListeners) {
            ICommandSender sender;
            if (!listener.isListening() || (sender = listener.getSender(server)) == null) continue;
            listen.addListener(sender);
        }
    }

    public static INotifyListener fromNBT(NBTTagCompound nbt) {
        switch (nbt.func_74762_e("Type")) {
            case 0: {
                return new INotifyListener.ServerListener(nbt);
            }
            case 1: {
                return new INotifyListener.PlayerListener(nbt);
            }
        }
        return null;
    }

    public static INotifyListener fromSender(ICommandSender sender, boolean listens) {
        if (sender instanceof EntityPlayer) {
            return new INotifyListener.PlayerListener((EntityPlayer)sender, listens);
        }
        if (sender instanceof MinecraftServer) {
            return new INotifyListener.ServerListener(listens);
        }
        return null;
    }
}

