/*
 * Decompiled with CFR 0.152.
 */
package lumien.custommainmenu.lib.textures;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import lumien.custommainmenu.lib.textures.ITexture;
import net.ellertonCMMShade.japng.Png;
import net.ellertonCMMShade.japng.argb8888.Argb8888Bitmap;
import net.ellertonCMMShade.japng.argb8888.Argb8888BitmapSequence;
import net.ellertonCMMShade.japng.chunks.PngAnimationControl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TextureApng
implements ITexture {
    ResourceLocation rl;
    HashMap<Argb8888BitmapSequence.Frame, Integer> frameTextureID;
    List<Argb8888BitmapSequence.Frame> frames;
    PngAnimationControl animationControl;
    int currentFrame;
    boolean loaded;
    boolean errored;
    long lastTimeStamp;
    int currentFrameDelay;

    public TextureApng(String textureString) {
        this.rl = new ResourceLocation(textureString);
        this.errored = false;
    }

    @Override
    public void bind() {
        if (!this.loaded) {
            this.load();
            this.loaded = true;
        }
        if (this.errored) {
            GlStateManager.func_179144_i((int)TextureUtil.field_111001_a.func_110552_b());
            return;
        }
        while (System.currentTimeMillis() - this.lastTimeStamp >= (long)this.currentFrameDelay) {
            ++this.currentFrame;
            if (this.currentFrame > this.animationControl.numFrames - 1) {
                this.currentFrame = 0;
            }
            Argb8888BitmapSequence.Frame f = this.frames.get(this.currentFrame);
            float numerator = f.control.delayNumerator;
            float denominator = f.control.delayDenominator > 0 ? (float)f.control.delayDenominator : 100.0f;
            this.lastTimeStamp += (long)this.currentFrameDelay;
            this.currentFrameDelay = (int)(numerator / denominator * 1000.0f);
        }
        GlStateManager.func_179144_i((int)this.frameTextureID.get(this.frames.get(this.currentFrame)));
    }

    private void load() {
        this.frameTextureID = new HashMap();
        try {
            InputStream inputStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.rl).func_110527_b();
            Argb8888BitmapSequence pngContainer = Png.readArgb8888BitmapSequence(inputStream);
            this.animationControl = pngContainer.getAnimationControl();
            this.frames = Collections.synchronizedList(pngContainer.getAnimationFrames());
            BufferedImage canvas = new BufferedImage(pngContainer.defaultImage.width, pngContainer.defaultImage.height, 2);
            Graphics2D graphics = canvas.createGraphics();
            graphics.setBackground(new Color(0, 0, 0, 0));
            BufferedImage frameBackup = new BufferedImage(pngContainer.defaultImage.width, pngContainer.defaultImage.height, 2);
            Graphics2D graphicsBackup = frameBackup.createGraphics();
            graphicsBackup.setBackground(new Color(0, 0, 0, 0));
            block11: for (int i = 0; i < this.frames.size(); ++i) {
                Argb8888BitmapSequence.Frame f = this.frames.get(i);
                switch (f.control.blendOp) {
                    case 0: {
                        graphics.setComposite(AlphaComposite.getInstance(2));
                        break;
                    }
                    case 1: {
                        graphics.setComposite(AlphaComposite.getInstance(3));
                    }
                }
                Argb8888Bitmap bitmap = f.bitmap;
                BufferedImage buffered = new BufferedImage(bitmap.width, bitmap.height, 2);
                buffered.setRGB(0, 0, bitmap.width, bitmap.height, bitmap.getPixelArray(), 0, bitmap.width);
                graphicsBackup.clearRect(0, 0, canvas.getWidth(), canvas.getHeight());
                graphicsBackup.drawImage(canvas, 0, 0, canvas.getWidth(), canvas.getHeight(), null);
                graphics.drawImage(buffered, f.control.xOffset, f.control.yOffset, f.control.xOffset + f.control.width, f.control.yOffset + f.control.height, 0, 0, buffered.getWidth(), buffered.getHeight(), null);
                this.frameTextureID.put(f, TextureUtil.func_110989_a((int)GL11.glGenTextures(), (BufferedImage)canvas, (boolean)false, (boolean)false));
                switch (f.control.disposeOp) {
                    case 0: {
                        continue block11;
                    }
                    case 1: {
                        graphics.clearRect(f.control.xOffset, f.control.yOffset, f.control.width, f.control.height);
                        continue block11;
                    }
                    case 2: {
                        graphics.clearRect(0, 0, canvas.getWidth(), canvas.getHeight());
                        graphics.drawImage(frameBackup, 0, 0, canvas.getWidth(), canvas.getHeight(), null);
                    }
                }
            }
            graphics.dispose();
            graphicsBackup.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errored = true;
            return;
        }
        Argb8888BitmapSequence.Frame frame = this.frames.get(0);
        float numerator = frame.control.delayNumerator;
        float denominator = frame.control.delayDenominator > 0 ? (float)frame.control.delayDenominator : 100.0f;
        this.currentFrameDelay = (int)(numerator / denominator * 1000.0f);
        this.lastTimeStamp = System.currentTimeMillis();
    }
}

