/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.progwidgets.ILiquidExport;
import me.desht.pneumaticcraft.common.progwidgets.ILiquidFiltered;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DroneAILiquidExport
extends DroneAIImExBase {
    public DroneAILiquidExport(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.fillTank(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        return this.fillTank(pos, false) && super.doBlockInteraction(pos, distToBlock);
    }

    private boolean fillTank(BlockPos pos, boolean simulate) {
        if (this.drone.getTank().getFluidAmount() == 0) {
            this.drone.addDebugEntry("gui.progWidget.liquidExport.debug.emptyDroneTank");
            this.abort();
            return false;
        }
        TileEntity te = this.drone.world().func_175625_s(pos);
        if (te != null) {
            FluidStack exportedFluid = this.drone.getTank().drain(Integer.MAX_VALUE, false);
            if (exportedFluid != null && ((ILiquidFiltered)((Object)this.widget)).isFluidValid(exportedFluid.getFluid())) {
                for (int i = 0; i < 6; ++i) {
                    IFluidHandler tank;
                    int filledAmount;
                    if (!((ISidedWidget)((Object)this.widget)).getSides()[i] || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.func_82600_a((int)i)) || (filledAmount = (tank = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.func_82600_a((int)i))).fill(exportedFluid, false)) <= 0) continue;
                    if (((ICountWidget)((Object)this.widget)).useCount()) {
                        filledAmount = Math.min(filledAmount, this.getRemainingCount());
                    }
                    if (!simulate) {
                        this.decreaseCount(tank.fill(this.drone.getTank().drain(filledAmount, true), true));
                    }
                    return true;
                }
                this.drone.addDebugEntry("gui.progWidget.liquidExport.debug.filledToMax", pos);
            } else {
                this.drone.addDebugEntry("gui.progWidget.liquidExport.debug.noValidFluid");
            }
        } else if (((ILiquidExport)((Object)this.widget)).isPlacingFluidBlocks() && (!((ICountWidget)((Object)this.widget)).useCount() || this.getRemainingCount() >= 1000)) {
            Block fluidBlock = this.drone.getTank().getFluid().getFluid().getBlock();
            if (this.drone.getTank().getFluidAmount() >= 1000 && fluidBlock != null && this.drone.world().func_175623_d(pos)) {
                if (!simulate) {
                    this.decreaseCount(1000);
                    this.drone.getTank().drain(1000, true);
                    this.drone.world().func_175656_a(pos, fluidBlock.func_176223_P());
                }
                return true;
            }
        }
        return false;
    }
}

