/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.network;

import io.netty.buffer.ByteBuf;
import net.malisis.advert.MalisisAdvert;
import net.malisis.advert.advert.Advert;
import net.malisis.advert.advert.ServerAdvert;
import net.malisis.advert.network.AdvertListMessage;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.registry.AutoLoad;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@AutoLoad(value=true)
public class AdvertSaveMessage
implements IMalisisMessageHandler<SavePacket, IMessage> {
    public AdvertSaveMessage() {
        MalisisAdvert.network.registerMessage((IMessageHandler)this, SavePacket.class, Side.SERVER);
    }

    public void process(SavePacket message, MessageContext ctx) {
        if (!(message instanceof SavePacket) || ctx.side != Side.SERVER) {
            return;
        }
        ServerAdvert advert = ServerAdvert.get(message.id, true);
        advert.setInfos(message.name, message.url);
        advert.save();
        AdvertListMessage.sendAdvert(advert);
    }

    public static void save(Advert advert) {
        SavePacket packet = new SavePacket(advert);
        MalisisAdvert.network.sendToServer((IMessage)packet);
    }

    public static class SavePacket
    implements IMessage {
        private int id;
        private String name;
        private String url;

        public SavePacket(Advert advert) {
            this.id = advert.getId();
            this.name = advert.getName();
            this.url = advert.getUrl();
        }

        public SavePacket() {
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.url = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.name == null ? "" : this.name));
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.url == null ? "" : this.url));
        }
    }
}

