/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets;

import com.direwolf20.buildinggadgets.common.config.SyncedConfig;
import com.direwolf20.buildinggadgets.common.items.ItemModBase;
import com.direwolf20.buildinggadgets.common.items.capability.CapabilityProviderBlockProvider;
import com.direwolf20.buildinggadgets.common.items.capability.CapabilityProviderEnergy;
import com.direwolf20.buildinggadgets.common.items.capability.MultiCapabilityProvider;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.NBTTool;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class GadgetGeneric
extends ItemModBase {
    public GadgetGeneric(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public int getEnergyMax() {
        return SyncedConfig.energyMax;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound tag) {
        return new MultiCapabilityProvider(new CapabilityProviderEnergy(stack, this::getEnergyMax), new CapabilityProviderBlockProvider(stack));
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage energy = CapabilityProviderEnergy.getCap(stack);
            return 1.0 - (double)energy.getEnergyStored() / (double)energy.getMaxEnergyStored();
        }
        return super.getDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage energy = CapabilityProviderEnergy.getCap(stack);
            return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f);
        }
        return super.getRGBDurabilityForDisplay(stack);
    }

    public boolean isDamaged(ItemStack stack) {
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage energy = CapabilityProviderEnergy.getCap(stack);
            return energy.getEnergyStored() != energy.getMaxEnergyStored();
        }
        return super.isDamaged(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("creative", 1)) {
            return false;
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage energy = CapabilityProviderEnergy.getCap(stack);
            return energy.getEnergyStored() != energy.getMaxEnergyStored();
        }
        return super.showDurabilityBar(stack);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        if (toRepair.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return false;
        }
        return repair.func_77973_b() == Items.field_151045_i;
    }

    public static ItemStack getGadget(EntityPlayer player) {
        ItemStack heldItem = player.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof GadgetGeneric) && !((heldItem = player.func_184592_cb()).func_77973_b() instanceof GadgetGeneric)) {
            return ItemStack.field_190927_a;
        }
        return heldItem;
    }

    public abstract int getEnergyCost(ItemStack var1);

    public abstract int getDamageCost(ItemStack var1);

    public boolean canUse(ItemStack tool, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (tool.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage energy = CapabilityProviderEnergy.getCap(tool);
            return this.getEnergyCost(tool) <= energy.getEnergyStored();
        }
        return tool.func_77958_k() <= 0 || tool.func_77952_i() < tool.func_77958_k() || tool.func_77984_f();
    }

    public void applyDamage(ItemStack tool, EntityPlayer player) {
        if (tool.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage energy = CapabilityProviderEnergy.getCap(tool);
            energy.extractEnergy(this.getEnergyCost(tool), false);
        } else {
            tool.func_77972_a(this.getDamageCost(tool), (EntityLivingBase)player);
        }
    }

    protected void addEnergyInformation(List<String> list, ItemStack stack) {
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage energy = CapabilityProviderEnergy.getCap(stack);
            list.add(TextFormatting.WHITE + I18n.func_135052_a((String)"tooltip.gadget.energy", (Object[])new Object[0]) + ": " + GadgetUtils.withSuffix(energy.getEnergyStored()) + "/" + GadgetUtils.withSuffix(energy.getMaxEnergyStored()));
        }
    }

    public static boolean getFuzzy(ItemStack stack) {
        return NBTTool.getOrNewTag(stack).func_74767_n("fuzzy");
    }

    public static void toggleFuzzy(EntityPlayer player, ItemStack stack) {
        NBTTool.getOrNewTag(stack).func_74757_a("fuzzy", !GadgetGeneric.getFuzzy(stack));
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.fuzzymode", new Object[0]).func_150261_e() + ": " + GadgetGeneric.getFuzzy(stack)), true);
    }

    public static boolean getConnectedArea(ItemStack stack) {
        return !NBTTool.getOrNewTag(stack).func_74767_n("unconnectedarea");
    }

    public static void toggleConnectedArea(EntityPlayer player, ItemStack stack) {
        NBTTool.getOrNewTag(stack).func_74757_a("unconnectedarea", GadgetGeneric.getConnectedArea(stack));
        String suffix = stack.func_77973_b() instanceof GadgetDestruction ? "area" : "surface";
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.connected" + suffix, new Object[0]).func_150261_e() + ": " + GadgetGeneric.getConnectedArea(stack)), true);
    }

    public static boolean shouldRayTraceFluid(ItemStack stack) {
        return NBTTool.getOrNewTag(stack).func_74767_n("raytrace_fluid");
    }

    public static void toggleRayTraceFluid(EntityPlayer player, ItemStack stack) {
        NBTTool.getOrNewTag(stack).func_74757_a("raytrace_fluid", !GadgetGeneric.shouldRayTraceFluid(stack));
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.raytrace_fluid", new Object[0]).func_150261_e() + ": " + GadgetGeneric.shouldRayTraceFluid(stack)), true);
    }

    public static void addInformationRayTraceFluid(List<String> tooltip, ItemStack stack) {
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.gadget.raytrace_fluid", (Object[])new Object[0]) + ": " + GadgetGeneric.shouldRayTraceFluid(stack));
    }

    public static class EmitEvent {
        protected static boolean breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(world, pos, state, player);
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            return !breakEvent.isCanceled();
        }

        protected static boolean placeBlock(EntityPlayer player, BlockSnapshot snapshot, EnumFacing facing, EnumHand hand) {
            BlockEvent.PlaceEvent event = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)snapshot, (EnumFacing)facing, (EnumHand)hand);
            return !event.isCanceled();
        }
    }
}

