/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.feature;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;

public class PlayerRadarManager {
    private final Map<UUID, EntityPlayer> playersOnServer;
    private static PlayerRadarManager INSTANCE;
    private final Object lock = new Object();

    private PlayerRadarManager() {
        this.playersOnServer = new HashMap<UUID, EntityPlayer>();
    }

    public static PlayerRadarManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlayerRadarManager();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<UUID, EntityPlayer> getPlayers() {
        Object object = this.lock;
        synchronized (object) {
            return this.playersOnServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(EntityPlayer player) {
        Object object = this.lock;
        synchronized (object) {
            this.playersOnServer.put(player.func_110124_au(), player);
        }
    }

    private void updateClientPlayer(EntityPlayer player) {
        EntityPlayer clientPlayer = this.getPlayers().get(player.func_110124_au());
        if (clientPlayer != null) {
            clientPlayer.field_70165_t = player.field_70165_t;
            clientPlayer.field_70163_u = player.field_70163_u;
            clientPlayer.field_70161_v = player.field_70161_v;
            clientPlayer.field_70176_ah = player.field_70176_ah;
            clientPlayer.field_70162_ai = player.field_70162_ai;
            clientPlayer.field_70164_aj = player.field_70164_aj;
            clientPlayer.field_70759_as = player.field_70759_as;
            clientPlayer.func_70095_a(player.func_70093_af());
        } else {
            this.addPlayer(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlayers(JsonArray playerList) {
        Object object = this.lock;
        synchronized (object) {
            for (JsonElement p : playerList) {
                JsonObject player = p.getAsJsonObject();
                EntityPlayer entityPlayer = this.buildPlayerFromJson(player);
                if (entityPlayer == null) continue;
                this.updateClientPlayer(entityPlayer);
            }
        }
    }

    private EntityPlayer buildPlayerFromJson(JsonObject player) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        UUID playerUUID = UUID.fromString(player.get("playerId").getAsString());
        String playerName = player.get("name").getAsString();
        if (!playerUUID.equals(mc.field_71439_g.func_110124_au())) {
            EntityOtherPlayerMP playerMp = new EntityOtherPlayerMP((World)mc.field_71441_e, new GameProfile(playerUUID, playerName));
            playerMp.field_70165_t = player.get("posX").getAsInt();
            playerMp.field_70163_u = player.get("posY").getAsInt();
            playerMp.field_70161_v = player.get("posZ").getAsInt();
            playerMp.field_70176_ah = player.get("chunkX").getAsInt();
            playerMp.field_70162_ai = player.get("chunkY").getAsInt();
            playerMp.field_70164_aj = player.get("chunkZ").getAsInt();
            playerMp.field_70759_as = player.get("rotation").getAsFloat();
            playerMp.func_70095_a(player.get("sneaking").getAsBoolean());
            playerMp.func_184221_a(playerUUID);
            playerMp.field_70175_ag = true;
            return playerMp;
        }
        return null;
    }
}

