/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.pdd;

import gcewing.sg.SGCraft;
import gcewing.sg.features.pdd.AddressData;
import gcewing.sg.features.pdd.AddressNameRegistry;
import gcewing.sg.features.pdd.network.PddNetworkHandler;
import gcewing.sg.network.GuiNetworkHandler;
import gcewing.sg.tileentity.DHDTE;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.util.GateUtil;
import gcewing.sg.util.SGState;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PddItem
extends Item {
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        if (!worldIn.field_72995_K && player.func_184614_ca().func_77973_b() == SGCraft.pdd) {
            TileEntity dhdBaseTE;
            TileEntity localGateTE;
            ItemStack stack = player.func_184614_ca();
            NBTTagCompound compound = stack.func_77978_p();
            if (compound == null) {
                compound = new NBTTagCompound();
            }
            if (!compound.func_74764_b("addresses")) {
                List<AddressData> genericAddressList = AddressNameRegistry.getDefaultPDDEntries();
                AddressData.writeAddresses(compound, genericAddressList);
                stack.func_77982_d(compound);
                player.field_71069_bz.func_75142_b();
            }
            if (!((localGateTE = GateUtil.locateLocalGate(worldIn, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), 6, false)) instanceof SGBaseTE) && (dhdBaseTE = GateUtil.locateDHD(worldIn, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), 6, false)) instanceof DHDTE) {
                DHDTE dhd = (DHDTE)dhdBaseTE;
                if (dhd.isLinkedToStargate) {
                    localGateTE = dhd.getLinkedStargateTE();
                }
            }
            if (localGateTE instanceof SGBaseTE) {
                boolean isPermissionsAdmin;
                SGBaseTE remoteGate;
                SGBaseTE localGate = (SGBaseTE)localGateTE;
                boolean canEditLocal = localGate.allowGateAccess(player.func_70005_c_());
                boolean canEditRemote = false;
                if (localGate.isConnected() && localGate.state == SGState.Connected && (remoteGate = localGate.getConnectedStargateTE()) != null) {
                    canEditRemote = remoteGate.allowGateAccess(player.func_70005_c_());
                }
                boolean bl = isPermissionsAdmin = SGCraft.hasPermissionSystem() && SGCraft.hasPermission(player, "sgcraft.admin");
                if (SGCraft.hasPermission(player, "sgcraft.gui.pdd")) {
                    if (player.func_70093_af()) {
                        List<AddressData> addresses = AddressData.getAddresses(compound);
                        String localGateAddress = localGate.homeAddress.toUpperCase().replace("-", "");
                        if (addresses.stream().noneMatch(data -> data.getAddress().replaceAll("-", "").equalsIgnoreCase(localGateAddress))) {
                            PddNetworkHandler.addPddEntryFromServer(player, localGateAddress);
                        } else {
                            SGBaseTE.sendErrorMsg(player, "pddContainsAddress", new Object[0]);
                        }
                    } else if (localGate.allowGateAccess(player.func_70005_c_()) || isPermissionsAdmin) {
                        GuiNetworkHandler.openGuiAtClient(localGate, player, 3, isPermissionsAdmin, canEditLocal, canEditRemote);
                    } else {
                        if (!SGCraft.hasPermission(player, "sgcraft.gui.pdd")) {
                            SGBaseTE.sendErrorMsg(player, "pddPermission", new Object[0]);
                        }
                        if (!localGate.allowGateAccess(player.func_70005_c_())) {
                            SGBaseTE.sendErrorMsg(player, "insufficientPlayerAccessPermission", new Object[0]);
                        }
                    }
                } else {
                    SGBaseTE.sendErrorMsg(player, "pddPermission", new Object[0]);
                }
                return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(handIn));
            }
            SGBaseTE.sendErrorMsg(player, "cantFindStargate", new Object[0]);
            return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(handIn));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(handIn));
    }
}

