/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseMod;
import gcewing.sg.BaseSubsystem;
import gcewing.sg.BaseTEChunkManager;
import gcewing.sg.SGCraftClient;
import gcewing.sg.block.DHDBlock;
import gcewing.sg.block.NaquadahBlock;
import gcewing.sg.block.NaquadahOreBlock;
import gcewing.sg.block.SGBaseBlock;
import gcewing.sg.block.SGPowerBlock;
import gcewing.sg.block.SGRingBlock;
import gcewing.sg.client.gui.SGGui;
import gcewing.sg.container.DHDFuelContainer;
import gcewing.sg.container.PowerContainer;
import gcewing.sg.container.SGBaseContainer;
import gcewing.sg.entity.EntityStargateIris;
import gcewing.sg.entity.SGEntity;
import gcewing.sg.features.configurator.ConfiguratorItem;
import gcewing.sg.features.configurator.network.ConfiguratorNetworkHandler;
import gcewing.sg.features.gdo.GdoItem;
import gcewing.sg.features.gdo.network.GdoNetworkHandler;
import gcewing.sg.features.ic2.zpm.ZpmInterfaceCart;
import gcewing.sg.features.ic2.zpm.ZpmInterfaceCartContainer;
import gcewing.sg.features.ic2.zpm.ZpmInterfaceCartTE;
import gcewing.sg.features.oc.OCIntegration;
import gcewing.sg.features.pdd.AddressNameRegistry;
import gcewing.sg.features.pdd.PddItem;
import gcewing.sg.features.pdd.network.PddNetworkHandler;
import gcewing.sg.features.tokra.SGTradeHandler;
import gcewing.sg.features.tokra.TokraVillagerWorldRegistry;
import gcewing.sg.features.zpm.ZPMItem;
import gcewing.sg.features.zpm.ZPMMultiplierRegistry;
import gcewing.sg.features.zpm.ZpmConsole;
import gcewing.sg.features.zpm.ZpmConsoleContainer;
import gcewing.sg.features.zpm.ZpmConsoleTE;
import gcewing.sg.generator.FeatureGeneration;
import gcewing.sg.generator.FeatureIgloo;
import gcewing.sg.generator.FeatureJungleTemple;
import gcewing.sg.generator.FeatureSwampHut;
import gcewing.sg.generator.FeatureUnderDesertPyramid;
import gcewing.sg.generator.GeneratorAddressRegistry;
import gcewing.sg.generator.NaquadahOreWorldGen;
import gcewing.sg.interfaces.IIntegration;
import gcewing.sg.interfaces.SoundSource;
import gcewing.sg.item.SGChevronUpgradeItem;
import gcewing.sg.item.SGIrisUpgradeItem;
import gcewing.sg.item.SGPegasusUpgradeItem;
import gcewing.sg.item.SGRingItem;
import gcewing.sg.network.GuiNetworkHandler;
import gcewing.sg.network.SGChannel;
import gcewing.sg.tileentity.DHDTE;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.util.GeneralAddressRegistry;
import gcewing.sg.util.PermissionsUtil;
import gcewing.sg.util.SGChunkData;
import gcewing.sg.util.Sound;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ninja.leaping.configurate.ConfigurationNode;

@Mod(modid="sgcraft", name="SG Craft", version="1.13.2", acceptableRemoteVersions="[1.13,1.14)", dependencies="after:opencomputers;after:ic2;after:computercraft;after:malisiscore", acceptedMinecraftVersions="[1.12.2]")
public class SGCraft
extends BaseMod<SGCraftClient> {
    public static final Material machineMaterial = new Material(MapColor.field_151668_h);
    public static SGCraft mod;
    public static SGChannel channel;
    public static BaseTEChunkManager chunkManager;
    public static SGBaseBlock sgBaseBlock;
    public static SGRingBlock sgRingBlock;
    public static DHDBlock sgControllerBlock;
    public static Block naquadahBlock;
    public static Block naquadahOre;
    public static SGPowerBlock sgPowerUnit;
    public static Item naquadah;
    public static Item naquadahIngot;
    public static Item sgCoreCrystal;
    public static Item sgControllerCrystal;
    public static Item sgChevronUpgrade;
    public static Item sgIrisUpgrade;
    public static Item sgIrisBlade;
    public static Item pegasus_upgrade;
    public static Item tollan_phase_shift_device;
    public static Block ic2PowerUnit;
    public static Item ic2Capacitor;
    public static boolean addOresToExistingWorlds;
    public static NaquadahOreWorldGen naquadahOreGenerator;
    public static BaseSubsystem ic2Integration;
    public static IIntegration ccIntegration;
    public static OCIntegration ocIntegration;
    public static Block zpm_interface_cart;
    public static Block zpm_console;
    public static Item zpm;
    public static Item gdo;
    public static Item pdd;
    public static Item configurator;
    public static CreativeTabs creativeTabs;
    public static VillagerRegistry.VillagerProfession tokraProfession;
    public static boolean canHarvestDHD;
    public static boolean canHarvestSGBaseBlock;
    public static boolean canHarvestSGRingBlock;
    public static int Ic2SafeInput;
    public static int Ic2MaxEnergyBuffer;
    public static double Ic2euPerSGEnergyUnit;
    public static int Ic2PowerTETier;
    public static int FPMaxEnergyBuffer;
    public static double FPPerSGEnergyUnit;
    public static double ZPMEnergyPerSGEnergyUnit;
    public static boolean useHDEventHorizionTexture;
    public static boolean saveAddressToClipboard;
    public static boolean displayGuiPowerDebug;
    public static boolean forceSGBaseTEUpdate;
    public static boolean forceDHDCfgUpdate;
    public static boolean forceIC2CfgUpdate;
    public static boolean forceFPCfgUpdate;
    public static boolean forceZPMCfgUpdate;
    public static boolean forceGateAccessSystemReset;
    public static boolean forcePlayerAccessSystemReset;
    public static boolean wormholeCanDestroyUnbreakableBlocks;
    public static PermissionsUtil permissionsUtil;

    public SGCraft() {
        mod = this;
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        this.creativeTab = new CreativeTabs("sgcraft:sgcraft"){

            public ItemStack func_78016_d() {
                return new ItemStack(Item.func_150898_a((Block)sgBaseBlock));
            }
        };
        FMLCommonHandler.instance().bus().register((Object)this);
        ic2Integration = this.integrateWithMod("ic2", "gcewing.sg.features.ic2.IC2Integration");
        ccIntegration = (IIntegration)((Object)this.integrateWithMod("computercraft", "gcewing.sg.features.cc.CCIntegration"));
        ocIntegration = (OCIntegration)this.integrateWithMod("opencomputers", "gcewing.sg.features.oc.OCIntegration");
        if (SGCraft.isModLoaded("ic2")) {
            GameRegistry.registerTileEntity(ZpmInterfaceCartTE.class, (ResourceLocation)new ResourceLocation(this.modID + ":tile_zpminterfacecart"));
        }
        GameRegistry.registerTileEntity(ZpmConsoleTE.class, (ResourceLocation)new ResourceLocation(this.modID + ":tile_zpmconsole"));
        super.preInit(e);
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        super.init(e);
        System.out.printf("SGCraft.init\n", new Object[0]);
        this.configure();
        channel = new SGChannel("sgcraft");
        chunkManager = new BaseTEChunkManager(this);
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        if (SGCraft.isModLoaded("spongeapi")) {
            permissionsUtil = new PermissionsUtil();
        } else {
            System.out.println("SGCraft - SpongeAPI not found, permissions system NOT initialized!");
        }
        super.postInit(e);
    }

    @Override
    protected SGCraftClient initClient() {
        return new SGCraftClient(this);
    }

    @Override
    void configure() {
        DHDTE.configure(this.config);
        NaquadahOreWorldGen.configure(this.config);
        SGBaseBlock.configure(this.config);
        SGBaseTE.configure(this.config);
        FeatureGeneration.configure(this.config);
        addOresToExistingWorlds = this.config.getBoolean("options", "addOresToExistingWorlds", false);
        useHDEventHorizionTexture = this.config.getBoolean("client", "useHDEventHorizonTexture", useHDEventHorizionTexture);
        saveAddressToClipboard = this.config.getBoolean("client", "saveAddressToClipboard", saveAddressToClipboard);
        displayGuiPowerDebug = this.config.getBoolean("client", "showPowerValuesOnGui", displayGuiPowerDebug);
        try {
            ConfigurationNode rootNode = ZPMMultiplierRegistry.createRootNode(Paths.get(".", "config", "SGCraft", "zpm.yml"));
            ZPMMultiplierRegistry.populateMultipliers(rootNode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ConfigurationNode tokraNode = TokraVillagerWorldRegistry.createRootNode(Paths.get(".", "config", "SGCraft", "tokra.yml"));
            TokraVillagerWorldRegistry.populateTokraVillagerWorlds(tokraNode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void registerOther() {
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
    }

    @Override
    protected void registerBlocks() {
        sgRingBlock = this.newBlock("stargateRing", SGRingBlock.class, SGRingItem.class);
        sgBaseBlock = this.newBlock("stargateBase", SGBaseBlock.class);
        sgControllerBlock = this.newBlock("stargateController", DHDBlock.class);
        naquadahBlock = this.newBlock("naquadahBlock", NaquadahBlock.class);
        naquadahOre = this.newBlock("naquadahOre", NaquadahOreBlock.class);
        sgPowerUnit = this.newBlock("sgPowerUnit", SGPowerBlock.class);
        if (SGCraft.isModLoaded("ic2")) {
            zpm_interface_cart = this.newBlock("zpm_interface_cart", ZpmInterfaceCart.class);
        }
        zpm_console = this.newBlock("zpm_console", ZpmConsole.class);
        this.setOptions();
    }

    @Override
    protected void registerItems() {
        ConfigurationNode rootNode;
        naquadah = this.newItem("naquadah");
        naquadahIngot = this.newItem("naquadahIngot");
        sgCoreCrystal = this.newItem("sgCoreCrystal");
        sgControllerCrystal = this.newItem("sgControllerCrystal");
        sgChevronUpgrade = this.addItem(new SGChevronUpgradeItem(), "sgChevronUpgrade");
        sgIrisUpgrade = this.addItem(new SGIrisUpgradeItem(), "sgIrisUpgrade");
        sgIrisBlade = this.newItem("sgIrisBlade");
        if (SGCraft.isModLoaded("ic2")) {
            ic2Capacitor = this.newItem("ic2Capacitor");
        }
        zpm = this.addItem(new ZPMItem(), "zpm");
        tollan_phase_shift_device = this.newItem("tollan_phase_shift_device");
        pegasus_upgrade = this.addItem(new SGPegasusUpgradeItem(), "pegasus_upgrade");
        if (SGCraft.isModLoaded("malisiscore")) {
            new GuiNetworkHandler("sgcraft-GUI");
            gdo = this.addItem(new GdoItem(), "gdo");
            new GdoNetworkHandler("sgcraft-gdo");
            pdd = this.addItem(new PddItem(), "pdd");
            new PddNetworkHandler("sgcraft-pdd");
            try {
                rootNode = AddressNameRegistry.createRootNode(Paths.get(".", "config", "SGCraft", "pdd.yml"));
                AddressNameRegistry.populateNames(rootNode);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            configurator = this.addItem(new ConfiguratorItem(), "configurator");
            new ConfiguratorNetworkHandler("sgcraft-configurator");
        }
        try {
            rootNode = GeneratorAddressRegistry.createRootNode(Paths.get(".", "config", "SGCraft", "generator.yml"));
            GeneratorAddressRegistry.populateAddresses(rootNode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ConfigurationNode rootNode2 = GeneralAddressRegistry.createRootNode(Paths.get(".", "config", "SGCraft", "general.yml"));
            GeneralAddressRegistry.populateAddresses(rootNode2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void playSound(SoundSource source, SoundEvent sound) {
        SGCraft.playSound(source, sound, SoundCategory.AMBIENT);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playSound(SoundSource source, SoundEvent sound, SoundCategory category) {
        SoundHandler soundHandler = SGCraft.getSoundHandler();
        soundHandler.func_147682_a((ISound)new Sound(source, sound, category));
    }

    @SideOnly(value=Side.CLIENT)
    private static SoundHandler getSoundHandler() {
        return Minecraft.func_71410_x().func_147118_V();
    }

    public static boolean isValidStargateUpgrade(Item item) {
        return item == sgChevronUpgrade || item == sgIrisUpgrade;
    }

    @Override
    protected void registerOres() {
        this.addOre("oreNaquadah", naquadahOre);
        this.addOre("naquadah", naquadah);
        this.addOre("ingotNaquadahAlloy", naquadahIngot);
    }

    @Override
    protected void registerRecipes() {
        ItemStack chiselledSandstone = new ItemStack(Blocks.field_150322_A, 1, 1);
        ItemStack smoothSandstone = new ItemStack(Blocks.field_150322_A, 1, 2);
        ItemStack sgChevronBlock = new ItemStack((Block)sgRingBlock, 1, 1);
        ItemStack blueDye = new ItemStack(Items.field_151100_aR, 1, 4);
        ItemStack orangeDye = new ItemStack(Items.field_151100_aR, 1, 14);
        if (this.config.getBoolean("recipes", "naquadah", false)) {
            this.newRecipe("naquadah", naquadah, 1, "aaa", "aaa", "bcd", Character.valueOf('a'), Blocks.field_150350_a, Character.valueOf('b'), Items.field_151044_h, Character.valueOf('c'), Items.field_151123_aH, Character.valueOf('d'), Items.field_151065_br);
        }
        if (this.config.getBoolean("recipes", "naquadahIngot", true)) {
            this.newShapelessRecipe("naquadahingot", naquadahIngot, 1, Ingredient.func_193367_a((Item)Items.field_151042_j), Ingredient.func_193367_a((Item)naquadah));
        }
        if (this.config.getBoolean("recipes", "naquadahIngotFromBlock", true)) {
            this.newRecipe("naquadahingot_from_block", naquadahIngot, 9, "B", Character.valueOf('B'), naquadahBlock);
        }
        if (this.config.getBoolean("recipes", "naquadahBlock", true)) {
            this.newRecipe("naquadahblock", naquadahBlock, 1, "NNN", "NNN", "NNN", Character.valueOf('N'), "ingotNaquadahAlloy");
        }
        if (this.config.getBoolean("recipes", "sgRingBlock", true)) {
            this.newRecipe("sgringblock", (Block)sgRingBlock, 1, "CCC", "NNN", "SSS", Character.valueOf('S'), smoothSandstone, Character.valueOf('N'), "ingotNaquadahAlloy", Character.valueOf('C'), chiselledSandstone);
        }
        if (this.config.getBoolean("recipes", "sgChevronBlock", true)) {
            this.newRecipe("sgcheveronblock", sgChevronBlock, "CgC", "NpN", "SrS", Character.valueOf('S'), smoothSandstone, Character.valueOf('N'), "ingotNaquadahAlloy", Character.valueOf('C'), chiselledSandstone, Character.valueOf('g'), Items.field_151114_aO, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('p'), Items.field_151079_bi);
        }
        if (this.config.getBoolean("recipes", "sgBaseBlock", true)) {
            this.newRecipe("sgbaseblock", (Block)sgBaseBlock, 1, "CrC", "NeN", "ScS", Character.valueOf('S'), smoothSandstone, Character.valueOf('N'), "ingotNaquadahAlloy", Character.valueOf('C'), chiselledSandstone, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('c'), sgCoreCrystal);
        }
        if (this.config.getBoolean("recipes", "sgControllerBlock", true)) {
            this.newRecipe("sgcontrollerblock", (Block)sgControllerBlock, 1, "bbb", "OpO", "OcO", Character.valueOf('b'), Blocks.field_150430_aB, Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('p'), Items.field_151079_bi, Character.valueOf('c'), sgControllerCrystal);
        }
        if (this.config.getBoolean("recipes", "sgChevronUpgradeItem", true)) {
            this.newRecipe("sgchevronupgrade", sgChevronUpgrade, 1, "g g", "pNp", "r r", Character.valueOf('N'), "ingotNaquadahAlloy", Character.valueOf('g'), Items.field_151114_aO, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('p'), Items.field_151079_bi);
        }
        if (this.config.getBoolean("recipes", "sgIrisBladeItem", true)) {
            this.newRecipe("sgirisblade", sgIrisBlade, 1, " ii", "ic ", "i  ", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('c'), new ItemStack(Items.field_151044_h, 1, 1));
        }
        if (this.config.getBoolean("recipes", "sgIrisUpgradeItem", true)) {
            this.newRecipe("sgirisupgrade", sgIrisUpgrade, 1, "bbb", "brb", "bbb", Character.valueOf('b'), sgIrisBlade, Character.valueOf('r'), Items.field_151137_ax);
        }
        if (this.config.getBoolean("recipes", "sgCoreCrystalItem", false)) {
            this.newRecipe("sgcorecrystal", sgCoreCrystal, 1, "bbr", "rdb", "brb", Character.valueOf('b'), blueDye, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('d'), Items.field_151045_i);
        }
        if (this.config.getBoolean("recipes", "sgControllerCrystalItem", false)) {
            this.newRecipe("sgcontrollercrystal", sgControllerCrystal, 1, "roo", "odr", "oor", Character.valueOf('o'), orangeDye, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('d'), Items.field_151045_i);
        }
        if (this.config.getBoolean("recipes", "sgPowerUnit", true)) {
            this.newRecipe("sgPowerUnit", (Block)sgPowerUnit, 1, "rgr", "zIz", "InI", Character.valueOf('n'), Blocks.field_150475_bE, Character.valueOf('z'), sgCoreCrystal, Character.valueOf('r'), Items.field_151166_bC, Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('I'), Blocks.field_150339_S);
        }
        if (this.config.getBoolean("recipes", "pegasus_upgrade", true)) {
            if (this.config.getBoolean("recipes", "pegasus_upgrade_require_crystal", true)) {
                this.newRecipe("pegasus_upgrade_0", pegasus_upgrade, 1, "glg", "rnr", "glg", Character.valueOf('g'), Items.field_151114_aO, Character.valueOf('l'), Blocks.field_150368_y, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('n'), sgCoreCrystal);
                this.newRecipe("pegasus_upgrade_1", pegasus_upgrade, 1, "grg", "lnl", "grg", Character.valueOf('g'), Items.field_151114_aO, Character.valueOf('l'), Blocks.field_150368_y, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('n'), sgCoreCrystal);
                this.newRecipe("pegasus_upgrade_2", pegasus_upgrade, 2, "glg", "rnr", "glg", Character.valueOf('g'), Items.field_151114_aO, Character.valueOf('l'), Blocks.field_150368_y, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('n'), pegasus_upgrade);
                this.newRecipe("pegasus_upgrade_3", pegasus_upgrade, 2, "grg", "lnl", "grg", Character.valueOf('g'), Items.field_151114_aO, Character.valueOf('l'), Blocks.field_150368_y, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('n'), pegasus_upgrade);
            } else {
                this.newRecipe("pegasus_upgrade_0", pegasus_upgrade, 1, "glg", "rnr", "glg", Character.valueOf('g'), Items.field_151114_aO, Character.valueOf('l'), Blocks.field_150368_y, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('n'), naquadahBlock);
                this.newRecipe("pegasus_upgrade_1", pegasus_upgrade, 1, "grg", "lnl", "grg", Character.valueOf('g'), Items.field_151114_aO, Character.valueOf('l'), Blocks.field_150368_y, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('n'), naquadahBlock);
            }
        }
        if (SGCraft.isModLoaded("malisiscore")) {
            if (this.config.getBoolean("recipes", "pdd", true)) {
                this.newRecipe("pdd", pdd, 1, "rcr", "nCn", "xbz", Character.valueOf('n'), naquadah, Character.valueOf('z'), sgCoreCrystal, Character.valueOf('x'), sgControllerCrystal, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('b'), Items.field_151099_bA, Character.valueOf('C'), Items.field_151113_aN, Character.valueOf('c'), Items.field_151111_aL);
            }
            if (this.config.getBoolean("recipes", "gdo", true)) {
                this.newRecipe("gdo", gdo, 1, "rCr", "xLz", "nbn", Character.valueOf('n'), naquadah, Character.valueOf('z'), sgCoreCrystal, Character.valueOf('x'), sgControllerCrystal, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('b'), Items.field_151099_bA, Character.valueOf('C'), Items.field_151113_aN, Character.valueOf('L'), Blocks.field_150442_at);
            }
        }
        if (this.config.getBoolean("recipes", "zpmConsole", true)) {
            this.newRecipe("zpmConsole", zpm_console, 1, "rgr", "xIz", "InI", Character.valueOf('n'), Blocks.field_150340_R, Character.valueOf('z'), sgCoreCrystal, Character.valueOf('x'), sgControllerCrystal, Character.valueOf('r'), Items.field_151166_bC, Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('I'), Blocks.field_150339_S);
        }
        if (!SGCraft.isModLoaded("ic2")) {
            this.addGenericCapacitorRecipe();
        }
    }

    protected void addGenericCapacitorRecipe() {
        if (this.config.getBoolean("recipes", "genericCapacitorItem", true)) {
            this.newRecipe("ic2capacitor", ic2Capacitor, 1, "iii", "ppp", "iii", Character.valueOf('i'), "ingotIron", Character.valueOf('p'), "paper");
        }
    }

    @Override
    protected void registerContainers() {
        this.addContainer(SGGui.SGBase, SGBaseContainer.class);
        this.addContainer(SGGui.DHDFuel, DHDFuelContainer.class);
        this.addContainer(SGGui.PowerUnit, PowerContainer.class);
        this.addContainer(SGGui.ZPMInterfaceCart, ZpmInterfaceCartContainer.class);
        this.addContainer(SGGui.ZPMConsole, ZpmConsoleContainer.class);
    }

    @Override
    protected void registerWorldGenerators() {
        if (this.config.getBoolean("options", "enableNaquadahOre", true)) {
            System.out.printf("SGCraft: Registering NaquadahOreWorldGen\n", new Object[0]);
            naquadahOreGenerator = new NaquadahOreWorldGen();
            GameRegistry.registerWorldGenerator((IWorldGenerator)naquadahOreGenerator, (int)0);
        }
        MapGenStructureIO.func_143031_a(FeatureUnderDesertPyramid.class, (String)"SGCraft:FeatureUnderDesertPyramid");
        MapGenStructureIO.func_143031_a(FeatureSwampHut.class, (String)"SGCraft:FeatureSwampHut");
        MapGenStructureIO.func_143031_a(FeatureIgloo.class, (String)"SGCraft:FeatureIgloo");
        MapGenStructureIO.func_143031_a(FeatureJungleTemple.class, (String)"SGCraft:FeatureJungleTemple");
    }

    @Override
    protected void registerVillagers() {
        tokraProfession = new VillagerRegistry.VillagerProfession("sgcraft:tokra", "sgcraft:textures/skins/tokra.png", "sgcraft:textures/skins/tokra.png");
        VillagerRegistry.VillagerCareer tokraCareer = new VillagerRegistry.VillagerCareer(tokraProfession, "sgcraft:tokra");
        tokraCareer.addTrade(1, new EntityVillager.ITradeList[]{new SGTradeHandler()});
        ForgeRegistries.VILLAGER_PROFESSIONS.register((IForgeRegistryEntry)tokraProfession);
    }

    @Override
    protected void registerEntities() {
        this.addEntity(EntityStargateIris.class, "stargate_iris", SGEntity.Iris, 1000000, false);
    }

    @Override
    protected void registerSounds() {
        SGBaseTE.registerSounds(this);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load e) {
        Chunk chunk = e.getChunk();
        SGChunkData.onChunkLoad(e);
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save e) {
        Chunk chunk = e.getChunk();
        SGChunkData.onChunkSave(e);
    }

    @SubscribeEvent
    public void onInitMapGen(InitMapGenEvent e) {
        FeatureGeneration.onInitMapGen(e);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        switch (e.phase) {
            case START: {
                for (BaseSubsystem om : this.subsystems) {
                    if (!(om instanceof IIntegration)) continue;
                    ((IIntegration)((Object)om)).onServerTick();
                }
                break;
            }
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload e) {
        Chunk chunk = e.getChunk();
        if (!chunk.func_177412_p().field_72995_K) {
            for (Object obj : chunk.func_177434_r().values()) {
                if (!(obj instanceof SGBaseTE)) continue;
                SGBaseTE te = (SGBaseTE)obj;
                te.disconnect();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelRegistry(ModelRegistryEvent event) {
        if (zpm_interface_cart != null) {
            this.registerModel(Item.func_150898_a((Block)zpm_interface_cart));
        }
        if (zpm_console != null) {
            this.registerModel(Item.func_150898_a((Block)zpm_console));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerModel(Item item) {
        this.registerInventoryModel(item, Objects.requireNonNull(item.getRegistryName()));
    }

    @SideOnly(value=Side.CLIENT)
    private void registerInventoryModel(Item item, ResourceLocation blockName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(blockName, "inventory"));
    }

    private void setOptions() {
        canHarvestDHD = this.config.getBoolean("block-harvest", "dhdBlock", canHarvestDHD);
        canHarvestSGBaseBlock = this.config.getBoolean("block-harvest", "sgBaseBlock", canHarvestSGBaseBlock);
        canHarvestSGRingBlock = this.config.getBoolean("block-harvest", "sgRingBlock", canHarvestSGRingBlock);
        Ic2SafeInput = this.config.getInteger("ic2", "safeInputRate", Ic2SafeInput);
        Ic2MaxEnergyBuffer = this.config.getInteger("ic2", "energyBufferSize", Ic2MaxEnergyBuffer);
        Ic2euPerSGEnergyUnit = this.config.getDouble("ic2", "euPerSGEnergyUnit", Ic2euPerSGEnergyUnit);
        Ic2PowerTETier = this.config.getInteger("ic2", "PowerTETier", Ic2PowerTETier);
        forceIC2CfgUpdate = this.config.getBoolean("ic2", "force-update", forceIC2CfgUpdate);
        FPMaxEnergyBuffer = this.config.getInteger("fp-power", "energyBufferSize", FPMaxEnergyBuffer);
        FPPerSGEnergyUnit = this.config.getDouble("fp-power", "fpPerSGEnergyUnit", FPPerSGEnergyUnit);
        forceFPCfgUpdate = this.config.getBoolean("fp-power", "force-update", forceFPCfgUpdate);
        ZPMEnergyPerSGEnergyUnit = this.config.getDouble("zpm-power", "zpmEnergyPerSGEnergyUnit", FPPerSGEnergyUnit);
        forceZPMCfgUpdate = this.config.getBoolean("zpm-power", "force-update", forceZPMCfgUpdate);
        forceSGBaseTEUpdate = this.config.getBoolean("stargate", "force-default-configs", forceSGBaseTEUpdate);
        forceDHDCfgUpdate = this.config.getBoolean("dhd", "force-update", forceDHDCfgUpdate);
        forceGateAccessSystemReset = this.config.getBoolean("gate-access", "force-reset-on-load", forceGateAccessSystemReset);
        forcePlayerAccessSystemReset = this.config.getBoolean("player-access", "force-reset-on-load", forcePlayerAccessSystemReset);
        wormholeCanDestroyUnbreakableBlocks = this.config.getBoolean("stargate", "wormholeCanDestroyUnbreakableBlocks", wormholeCanDestroyUnbreakableBlocks);
    }

    public static boolean hasPermission(EntityPlayer player, String permission) {
        if (SGCraft.isModLoaded("spongeapi")) {
            return PermissionsUtil.spongeHasPermission(player, permission);
        }
        return true;
    }

    public static boolean hasPermissionSystem() {
        return SGCraft.isModLoaded("spongeapi");
    }

    static {
        canHarvestDHD = false;
        canHarvestSGBaseBlock = false;
        canHarvestSGRingBlock = false;
        Ic2SafeInput = 2048;
        Ic2MaxEnergyBuffer = 1000000;
        Ic2euPerSGEnergyUnit = 20.0;
        Ic2PowerTETier = 3;
        FPMaxEnergyBuffer = 4000000;
        FPPerSGEnergyUnit = 80.0;
        ZPMEnergyPerSGEnergyUnit = 10.0;
        useHDEventHorizionTexture = true;
        saveAddressToClipboard = false;
        displayGuiPowerDebug = true;
        forceSGBaseTEUpdate = false;
        forceDHDCfgUpdate = false;
        forceIC2CfgUpdate = false;
        forceFPCfgUpdate = false;
        forceZPMCfgUpdate = false;
        forceGateAccessSystemReset = false;
        forcePlayerAccessSystemReset = false;
        wormholeCanDestroyUnbreakableBlocks = false;
    }
}

