/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.passive;

import com.google.common.collect.Lists;
import gregtech.api.capability.GregtechCapabilities;
import java.util.List;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.ItemIngredient;
import nc.tile.energy.ITileEnergy;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.tile.passive.ITilePassive;
import nc.util.EnergyHelper;
import nc.util.GasHelper;
import nc.util.ItemStackHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TilePassiveAbstract
extends TileEnergyFluidSidedInventory
implements ITilePassive {
    protected int tickCount;
    protected int pushCount;
    public final int updateRate;
    public final int pushRate;
    public boolean isActive;
    public boolean energyBool;
    public boolean stackBool;
    public boolean fluidBool;
    public final int energyChange;
    public IItemIngredient stackChange;
    public final int itemChange;
    public final int fluidChange;
    public final FluidStack fluidStackChange;
    public final Fluid fluidType;

    public TilePassiveAbstract(String name, int energyChange, int changeRate) {
        this(name, new ItemIngredient(new ItemStack(Items.field_151082_bd)), 0, energyChange, FluidRegistry.LAVA, 0, changeRate);
    }

    public TilePassiveAbstract(String name, IItemIngredient item, int itemChange, int changeRate) {
        this(name, item, itemChange, 0, FluidRegistry.LAVA, 0, changeRate);
    }

    public TilePassiveAbstract(String name, Fluid fluid, int fluidChange, int changeRate) {
        this(name, new ItemIngredient(new ItemStack(Items.field_151082_bd)), 0, 0, fluid, fluidChange, changeRate);
    }

    public TilePassiveAbstract(String name, Fluid fluid, int fluidChange, int changeRate, List<String> fluidTypes) {
        this(name, new ItemIngredient(new ItemStack(Items.field_151082_bd)), 0, 0, fluid, fluidChange, changeRate, fluidTypes);
    }

    public TilePassiveAbstract(String name, IItemIngredient item, int itemChange, int energyChange, int changeRate) {
        this(name, item, itemChange, energyChange, FluidRegistry.LAVA, 0, changeRate);
    }

    public TilePassiveAbstract(String name, int energyChange, Fluid fluid, int fluidChange, int changeRate) {
        this(name, new ItemIngredient(new ItemStack(Items.field_151082_bd)), 0, energyChange, fluid, fluidChange, changeRate);
    }

    public TilePassiveAbstract(String name, IItemIngredient item, int itemChange, Fluid fluid, int fluidChange, int changeRate) {
        this(name, item, itemChange, 0, fluid, fluidChange, changeRate);
    }

    public TilePassiveAbstract(String name, IItemIngredient item, int itemChange, int energyChange, Fluid fluid, int fluidChange, int changeRate) {
        this(name, item, itemChange, energyChange, fluid, fluidChange, changeRate, Lists.newArrayList((Object[])new String[]{fluid.getName()}));
    }

    public TilePassiveAbstract(String name, IItemIngredient item, int itemChange, int energyChange, Fluid fluid, int fluidChange, int changeRate, List<String> fluidTypes) {
        super(name, 1, itemChange > 0 ? ITileInventory.inventoryConnectionAll(ItemSorption.OUT) : (itemChange < 0 ? ITileInventory.inventoryConnectionAll(ItemSorption.IN) : ITileInventory.inventoryConnectionAll(ItemSorption.NON)), energyChange == 0 ? 1 : NCConfig.rf_per_eu * MathHelper.func_76130_a((int)energyChange) * changeRate, energyChange == 0 ? 0 : NCConfig.rf_per_eu * MathHelper.func_76130_a((int)energyChange), energyChange > 0 ? ITileEnergy.energyConnectionAll(EnergyConnection.OUT) : (energyChange < 0 ? ITileEnergy.energyConnectionAll(EnergyConnection.IN) : ITileEnergy.energyConnectionAll(EnergyConnection.NON)), fluidChange == 0 ? 1 : 6 * MathHelper.func_76130_a((int)fluidChange) * changeRate, fluidTypes, fluidChange > 0 ? ITileFluid.fluidConnectionAll(TankSorption.OUT) : (fluidChange < 0 ? ITileFluid.fluidConnectionAll(TankSorption.IN) : ITileFluid.fluidConnectionAll(TankSorption.NON)));
        this.energyChange = energyChange * changeRate;
        this.itemChange = itemChange * changeRate;
        this.stackChange = new ItemIngredient(ItemStackHelper.changeStackSize((ItemStack)item.getStack(), MathHelper.func_76130_a((int)itemChange) * changeRate));
        this.fluidChange = fluidChange * changeRate;
        this.fluidStackChange = new FluidStack(fluid, MathHelper.func_76130_a((int)fluidChange) * changeRate);
        this.fluidType = fluid;
        this.updateRate = changeRate * 20;
        this.pushRate = Math.min(changeRate * 20, NCConfig.machine_update_rate);
    }

    @Override
    public void func_73660_a() {
        boolean wasActive = this.isActive;
        boolean shouldUpdate = false;
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.tickCount == 0) {
                this.energyBool = this.changeEnergy(false);
                this.stackBool = this.changeStack(false);
                this.fluidBool = this.changeFluid(false);
            }
            this.isActive = this.isRunning(this.energyBool, this.stackBool, this.fluidBool);
            if (wasActive != this.isActive) {
                shouldUpdate = true;
                this.updateBlockType();
            }
            if (this.pushCount == 0) {
                if (NCConfig.passive_push) {
                    if (this.itemChange > 0) {
                        this.pushStacks();
                    }
                    if (this.fluidChange > 0) {
                        this.pushFluid();
                    }
                }
                if (this.energyChange > 0) {
                    this.pushEnergy();
                }
            }
            this.tickCount();
            this.tickPush();
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    public void tickCount() {
        ++this.tickCount;
        this.tickCount %= this.updateRate;
    }

    public void tickPush() {
        ++this.pushCount;
        this.pushCount %= this.pushRate;
    }

    public void updateBlockType() {
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
        this.setState(this.isActive, this);
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        if (ModCheck.ic2Loaded()) {
            this.addTileToENet();
        }
    }

    protected boolean changeEnergy(boolean simulateChange) {
        if (this.energyChange == 0) {
            return simulateChange;
        }
        if (this.getEnergyStorage().getEnergyStored() >= this.getEnergyStorage().getMaxEnergyStored() && this.energyChange > 0) {
            return false;
        }
        if (this.getEnergyStorage().getEnergyStored() < MathHelper.func_76130_a((int)this.energyChange) && this.energyChange < 0) {
            return false;
        }
        if (!simulateChange && this.changeStack(true) && this.changeFluid(true)) {
            this.getEnergyStorage().changeEnergyStored(this.energyChange);
        }
        return true;
    }

    protected boolean changeStack(boolean simulateChange) {
        if (this.itemChange == 0) {
            return simulateChange;
        }
        if (!(this.stackChange.match(this.getInventoryStacks().get(0), IngredientSorption.NEUTRAL).matches() || ((ItemStack)this.getInventoryStacks().get(0)).func_190926_b() || simulateChange)) {
            this.getInventoryStacks().set(0, (Object)ItemStack.field_190927_a);
        }
        if (this.itemChange > 0) {
            if (!((ItemStack)this.getInventoryStacks().get(0)).func_190926_b() && ((ItemStack)this.getInventoryStacks().get(0)).func_190916_E() + this.itemChange > this.getInventoryStackLimit()) {
                return false;
            }
            if (((ItemStack)this.getInventoryStacks().get(0)).func_190926_b() && !simulateChange) {
                if (this.changeEnergy(true) && this.changeFluid(true)) {
                    this.setNewStack();
                }
            } else if (!simulateChange && this.changeEnergy(true) && this.changeFluid(true)) {
                ((ItemStack)this.getInventoryStacks().get(0)).func_190917_f(this.itemChange);
            }
            return true;
        }
        if (((ItemStack)this.getInventoryStacks().get(0)).func_190926_b() || ((ItemStack)this.getInventoryStacks().get(0)).func_190916_E() < MathHelper.func_76130_a((int)this.itemChange)) {
            return false;
        }
        if (((ItemStack)this.getInventoryStacks().get(0)).func_190916_E() > MathHelper.func_76130_a((int)this.itemChange) && !simulateChange) {
            if (this.changeEnergy(true) && this.changeFluid(true)) {
                ((ItemStack)this.getInventoryStacks().get(0)).func_190917_f(this.itemChange);
            }
        } else if (((ItemStack)this.getInventoryStacks().get(0)).func_190916_E() == MathHelper.func_76130_a((int)this.itemChange) && !simulateChange && this.changeEnergy(true) && this.changeFluid(true)) {
            this.getInventoryStacks().set(0, (Object)ItemStack.field_190927_a);
        }
        return true;
    }

    protected void setNewStack() {
        this.getInventoryStacks().set(0, this.stackChange.getStack());
    }

    protected boolean changeFluid(boolean simulateChange) {
        if (this.fluidChange == 0) {
            return simulateChange;
        }
        if (this.getTanks().get(0).getFluidAmount() >= this.getTanks().get(0).getCapacity() && this.fluidChange > 0) {
            return false;
        }
        if (this.getTanks().get(0).getFluidAmount() < MathHelper.func_76130_a((int)this.fluidChange) && this.fluidChange < 0) {
            return false;
        }
        if (!simulateChange && this.changeEnergy(true) && this.changeStack(true)) {
            if (this.fluidChange > 0) {
                if (this.fluidStackChange != null) {
                    this.getTanks().get(0).changeFluidStored(this.fluidType, this.fluidChange);
                }
            } else {
                this.getTanks().get(0).changeFluidAmount(this.fluidChange);
            }
        }
        return true;
    }

    protected boolean isRunning(boolean energy, boolean stack, boolean fluid) {
        if (this.energyChange == 0 && this.itemChange == 0 && this.fluidChange == 0) {
            return true;
        }
        if (this.energyChange >= 0) {
            if (this.itemChange >= 0) {
                if (this.fluidChange >= 0) {
                    return energy || stack || fluid;
                }
                return fluid;
            }
            if (this.fluidChange >= 0) {
                return stack;
            }
            return stack && fluid;
        }
        if (this.itemChange >= 0) {
            if (this.fluidChange >= 0) {
                return energy;
            }
            return energy && fluid;
        }
        if (this.fluidChange >= 0) {
            return energy && stack;
        }
        return energy && stack && fluid;
    }

    @Override
    public int getEnergyChange() {
        return this.energyChange;
    }

    @Override
    public int getItemChange() {
        return this.itemChange;
    }

    @Override
    public int getFluidChange() {
        return this.fluidChange;
    }

    @Override
    public boolean canPushEnergyTo() {
        return this.energyChange < 0;
    }

    @Override
    public boolean canPushItemsTo() {
        return this.itemChange < 0;
    }

    @Override
    public boolean canPushFluidsTo() {
        return this.fluidChange < 0;
    }

    @Override
    public int getInventoryStackLimit() {
        return this.itemChange == 0 ? 1 : 6 * MathHelper.func_76130_a((int)this.itemChange);
    }

    @Override
    public int[] getSlotsForFace(EnumFacing side) {
        return new int[]{0};
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, EnumFacing side) {
        return this.itemChange < 0 && super.canInsertItem(slot, stack, side) && this.stackChange.match(stack, IngredientSorption.NEUTRAL).matches();
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, EnumFacing side) {
        return this.itemChange > 0 && super.canExtractItem(slot, stack, side);
    }

    @Override
    public int getEUSourceTier() {
        return EnergyHelper.getEUTier(this.energyChange);
    }

    @Override
    public int getEUSinkTier() {
        return 10;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74757_a("isRunning", this.isActive);
        nbt.func_74757_a("energyBool", this.energyBool);
        nbt.func_74757_a("stackBool", this.stackBool);
        nbt.func_74757_a("fluidBool", this.fluidBool);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.isActive = nbt.func_74767_n("isRunning");
        this.energyBool = nbt.func_74767_n("energyBool");
        this.stackBool = nbt.func_74767_n("stackBool");
        this.fluidBool = nbt.func_74767_n("fluidBool");
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return this.getRadiationSource() != null;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return this.energyChange != 0 && this.hasEnergySideCapability(side);
        }
        if (ModCheck.gregtechLoaded() && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            return NCConfig.enable_gtce_eu && this.energyChange != 0 && this.hasEnergySideCapability(side);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidChange != 0 && this.hasFluidSideCapability(side);
        }
        if (ModCheck.mekanismLoaded() && capability == GasHelper.GAS_HANDLER_CAPABILITY) {
            return NCConfig.enable_mek_gas && this.fluidChange != 0 && this.hasFluidSideCapability(side);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemChange != 0;
        }
        return this.hasCapabilityDefault(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return (T)this.getRadiationSource();
        }
        if (capability == CapabilityEnergy.ENERGY) {
            if (this.energyChange != 0 && this.hasEnergySideCapability(side)) {
                return (T)this.getEnergySide(this.nonNullSide(side));
            }
            return null;
        }
        if (ModCheck.gregtechLoaded() && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            if (NCConfig.enable_gtce_eu && this.energyChange != 0 && this.hasEnergySideCapability(side)) {
                return (T)this.getEnergySideGT(this.nonNullSide(side));
            }
            return null;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.fluidChange != 0 && this.hasFluidSideCapability(side)) {
                return (T)this.getFluidSide(this.nonNullSide(side));
            }
            return null;
        }
        if (ModCheck.mekanismLoaded() && capability == GasHelper.GAS_HANDLER_CAPABILITY) {
            if (NCConfig.enable_mek_gas && this.fluidChange != 0 && this.hasFluidSideCapability(side)) {
                return (T)this.getGasWrapper();
            }
            return null;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.itemChange != 0) {
                return (T)this.getItemHandlerCapability(null);
            }
            return null;
        }
        return this.getCapabilityDefault(capability, side);
    }
}

