/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.recipes.IRecipeInput;

public class ItemUtils {
    public static boolean isItemEqual(ItemStack a, ItemStack b, boolean matchDamage, boolean matchNBT) {
        if (a.func_190926_b() || b.func_190926_b()) {
            return false;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (matchNBT && !ItemStack.func_77970_a((ItemStack)a, (ItemStack)b)) {
            return false;
        }
        if (matchDamage && a.func_77981_g()) {
            if (ItemUtils.isWildcard(a) || ItemUtils.isWildcard(b)) {
                return true;
            }
            if (a.func_77952_i() != b.func_77952_i()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b, boolean matchDamage, boolean matchNBT, boolean useOreDic) {
        if (ItemUtils.isItemEqual(a, b, matchDamage, matchNBT)) {
            return true;
        }
        if (a.func_190926_b() || b.func_190926_b()) {
            return false;
        }
        if (useOreDic) {
            for (int inta : OreDictionary.getOreIDs((ItemStack)a)) {
                for (int intb : OreDictionary.getOreIDs((ItemStack)b)) {
                    if (inta != intb) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isInputEqual(Object input, ItemStack other, boolean matchDamage, boolean matchNBT, boolean useOreDic) {
        block4: {
            block3: {
                if (input instanceof ItemStack) {
                    return ItemUtils.isItemEqual((ItemStack)input, other, matchDamage, matchNBT, useOreDic);
                }
                if (!(input instanceof String)) break block3;
                NonNullList ores = OreDictionary.getOres((String)((String)input));
                for (ItemStack stack : ores) {
                    if (!ItemUtils.isItemEqual(stack, other, matchDamage, matchNBT, false)) continue;
                    return true;
                }
                break block4;
            }
            if (!(input instanceof IRecipeInput)) break block4;
            List<ItemStack> inputs = ((IRecipeInput)input).getAllStacks();
            for (ItemStack stack : inputs) {
                if (!ItemUtils.isItemEqual(stack, other, matchDamage, matchNBT, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWildcard(ItemStack stack) {
        return ItemUtils.isWildcard(stack.func_77952_i());
    }

    public static boolean isWildcard(int damage) {
        return damage == -1 || damage == Short.MAX_VALUE;
    }

    public static void writeInvToNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = new NBTTagList();
        for (byte slot = 0; slot < inv.func_70302_i_(); slot = (byte)((byte)(slot + 1))) {
            ItemStack stack = inv.func_70301_a((int)slot);
            if (stack.func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", slot);
            ItemUtils.writeItemToNBT(stack, itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        data.func_74782_a(tag, (NBTBase)list);
    }

    public static void readInvFromNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = data.func_150295_c(tag, 10);
        for (int entry = 0; entry < list.func_74745_c(); entry = (int)((byte)(entry + 1))) {
            NBTTagCompound itemTag = list.func_150305_b(entry);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= inv.func_70302_i_()) continue;
            ItemStack stack = ItemUtils.readItemFromNBT(itemTag);
            inv.func_70299_a((int)slot, stack);
        }
    }

    public static List<ItemStack> getStackWithAllOre(ItemStack stack) {
        if (stack.func_190926_b()) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
            for (ItemStack ore : OreDictionary.getOres((String)OreDictionary.getOreName((int)oreID))) {
                ItemStack newOre = ore.func_77946_l();
                newOre.func_190920_e(stack.func_190916_E());
                list.add(newOre);
            }
        }
        if (list.isEmpty()) {
            list.add(stack);
        }
        return list;
    }

    public static ItemStack readItemFromNBT(NBTTagCompound data) {
        return new ItemStack(data);
    }

    public static void writeItemToNBT(ItemStack stack, NBTTagCompound data) {
        if (ItemUtils.isEmpty(stack)) {
            return;
        }
        if (stack.func_190916_E() > 127) {
            stack.func_190920_e(127);
        }
        stack.func_77955_b(data);
    }

    public static double getPowerForDurabilityBar(ItemStack stack) {
        if (ItemUtils.isEmpty(stack)) {
            return 0.0;
        }
        if (!(stack.func_77973_b() instanceof IEnergyItemInfo)) {
            return 0.0;
        }
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
        return (double)capEnergy.getEnergyStored() / (double)capEnergy.getMaxEnergyStored();
    }

    public static boolean isActive(ItemStack stack) {
        NBTTagCompound nbt;
        if (!ItemUtils.isEmpty(stack) && (nbt = ItemUtils.getStackNbtData(stack)).func_74764_b("isActive")) {
            return nbt.func_74767_n("isActive");
        }
        return false;
    }

    public static NBTTagCompound getStackNbtData(ItemStack stack) {
        NBTTagCompound ret = stack.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            stack.func_77982_d(ret);
        }
        return ret;
    }

    public static boolean isEmpty(ItemStack stack) {
        return stack == ItemStack.field_190927_a || stack == null || stack.func_190916_E() <= 0;
    }

    public static int getSize(ItemStack stack) {
        return ItemUtils.isEmpty(stack) ? 0 : stack.func_190916_E();
    }

    public static ItemStack setSize(ItemStack stack, int size) {
        if (size <= 0) {
            return ItemStack.field_190927_a;
        }
        stack.func_190920_e(size);
        return stack;
    }

    public static ItemStack increaseSize(ItemStack stack, int amount) {
        return ItemUtils.setSize(stack, ItemUtils.getSize(stack) + amount);
    }

    public static ItemStack increaseSize(ItemStack stack) {
        return ItemUtils.increaseSize(stack, 1);
    }

    public static ItemStack decreaseSize(ItemStack stack, int amount) {
        return ItemUtils.setSize(stack, ItemUtils.getSize(stack) - amount);
    }

    public static ItemStack decreaseSize(ItemStack stack) {
        return ItemUtils.decreaseSize(stack, 1);
    }

    public static ItemStack copyWithSize(ItemStack stack, int size) {
        if (ItemUtils.isEmpty(stack)) {
            return ItemStack.field_190927_a;
        }
        return ItemUtils.setSize(stack.func_77946_l(), size);
    }

    public static void dropToWorld(World world, BlockPos pos, ItemStack stack) {
        if (ItemUtils.isEmpty(stack)) {
            return;
        }
        double f = 0.7;
        double dx = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dy = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dz = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + dx, (double)pos.func_177956_o() + dy, (double)pos.func_177952_p() + dz, stack.func_77946_l());
        entityItem.func_174869_p();
        world.func_72838_d((Entity)entityItem);
    }

    public static String toFormattedString(ItemStack itemStack) {
        return itemStack == null ? "(null)" : (itemStack.func_77973_b() == null ? ItemUtils.getSize(itemStack) + "x(null)@(unknown)" : itemStack.toString());
    }
}

