/*
 * Decompiled with CFR 0.152.
 */
package reborncore.api.praescriptum.Utils;

import java.util.function.Consumer;
import java.util.function.Predicate;
import reborncore.api.praescriptum.ingredients.Ingredient;
import reborncore.api.praescriptum.recipes.RecipeHandler;

public class IngredientUtils {
    public static <T extends Ingredient> Predicate<T> isIngredientEmpty() {
        return Ingredient::isEmpty;
    }

    public static <T extends Ingredient> Predicate<T> isIngredientEmpty(Consumer<T> action) {
        return ingredient -> {
            boolean isEmpty = ingredient.isEmpty();
            if (isEmpty) {
                action.accept(ingredient);
            }
            return !isEmpty;
        };
    }

    public static <T> Predicate<T> isPartOfRecipe(RecipeHandler handler) {
        return object -> handler.getRecipes().stream().anyMatch(recipe -> recipe.getInputIngredients().stream().anyMatch(ingredient -> ingredient.matches(object)));
    }
}

