/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.Types;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ConfigurationNode {
    public static final int NUMBER_DEF = 0;

    public @Nullable Object getKey();

    public @NonNull Object[] getPath();

    public @Nullable ConfigurationNode getParent();

    public @NonNull ConfigurationNode getNode(Object ... var1);

    public boolean isVirtual();

    public @NonNull ConfigurationOptions getOptions();

    public boolean hasListChildren();

    public boolean hasMapChildren();

    public @NonNull List<? extends ConfigurationNode> getChildrenList();

    public @NonNull Map<Object, ? extends ConfigurationNode> getChildrenMap();

    default public @Nullable Object getValue() {
        return this.getValue((Object)null);
    }

    public Object getValue(@Nullable Object var1);

    public Object getValue(@NonNull Supplier<Object> var1);

    default public <T> @Nullable T getValue(@NonNull Function<Object, T> transformer) {
        return this.getValue(transformer, (T)null);
    }

    public <T> T getValue(@NonNull Function<Object, T> var1, @Nullable T var2);

    public <T> T getValue(@NonNull Function<Object, T> var1, @NonNull Supplier<T> var2);

    public <T> @NonNull List<T> getList(@NonNull Function<Object, T> var1);

    public <T> List<T> getList(@NonNull Function<Object, T> var1, @Nullable List<T> var2);

    public <T> List<T> getList(@NonNull Function<Object, T> var1, @NonNull Supplier<List<T>> var2);

    default public <T> @NonNull List<T> getList(@NonNull TypeToken<T> type) throws ObjectMappingException {
        return this.getList(type, (List<T>)ImmutableList.of());
    }

    public <T> List<T> getList(@NonNull TypeToken<T> var1, @Nullable List<T> var2) throws ObjectMappingException;

    public <T> List<T> getList(@NonNull TypeToken<T> var1, @NonNull Supplier<List<T>> var2) throws ObjectMappingException;

    default public @Nullable String getString() {
        return this.getString(null);
    }

    default public String getString(@Nullable String def) {
        return this.getValue(Types::asString, def);
    }

    default public float getFloat() {
        return this.getFloat(0.0f);
    }

    default public float getFloat(float def) {
        return this.getValue(Types::asFloat, Float.valueOf(def)).floatValue();
    }

    default public double getDouble() {
        return this.getDouble(0.0);
    }

    default public double getDouble(double def) {
        return this.getValue(Types::asDouble, Double.valueOf(def));
    }

    default public int getInt() {
        return this.getInt(0);
    }

    default public int getInt(int def) {
        return this.getValue(Types::asInt, Integer.valueOf(def));
    }

    default public long getLong() {
        return this.getLong(0L);
    }

    default public long getLong(long def) {
        return this.getValue(Types::asLong, Long.valueOf(def));
    }

    default public boolean getBoolean() {
        return this.getBoolean(false);
    }

    default public boolean getBoolean(boolean def) {
        return this.getValue(Types::asBoolean, Boolean.valueOf(def));
    }

    default public <T> @Nullable T getValue(@NonNull TypeToken<T> type) throws ObjectMappingException {
        return this.getValue(type, (T)null);
    }

    public <T> T getValue(@NonNull TypeToken<T> var1, T var2) throws ObjectMappingException;

    public <T> T getValue(@NonNull TypeToken<T> var1, @NonNull Supplier<T> var2) throws ObjectMappingException;

    public @NonNull ConfigurationNode setValue(@Nullable Object var1);

    default public <T> @NonNull ConfigurationNode setValue(@NonNull TypeToken<T> type, @Nullable T value) throws ObjectMappingException {
        if (value == null) {
            this.setValue(null);
            return this;
        }
        TypeSerializer<T> serial = this.getOptions().getSerializers().get(type);
        if (serial != null) {
            serial.serialize(type, value, this);
        } else if (this.getOptions().acceptsType(value.getClass())) {
            this.setValue(value);
        } else {
            throw new ObjectMappingException("No serializer available for type " + type);
        }
        return this;
    }

    public @NonNull ConfigurationNode mergeValuesFrom(@NonNull ConfigurationNode var1);

    public boolean removeChild(@NonNull Object var1);

    public @NonNull ConfigurationNode getAppendedNode();
}

