/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackValidatedNBT;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CrucibleManager {
    private static Map<ComparableItemStackValidatedNBT, CrucibleRecipe> recipeMap = new Object2ObjectOpenHashMap();
    private static Set<ComparableItemStackValidatedNBT> lavaSet = new ObjectOpenHashSet();
    public static final int DEFAULT_ENERGY = 8000;

    public static CrucibleRecipe getRecipe(ItemStack input) {
        return input.func_190926_b() ? null : recipeMap.get(new ComparableItemStackValidatedNBT(input));
    }

    public static boolean recipeExists(ItemStack input) {
        return CrucibleManager.getRecipe(input) != null;
    }

    public static CrucibleRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new CrucibleRecipe[0]);
    }

    public static boolean isLava(ItemStack input) {
        return !input.func_190926_b() && lavaSet.contains(new ComparableItemStackValidatedNBT(input));
    }

    public static void initialize() {
    }

    public static void refresh() {
        Object2ObjectOpenHashMap tempMap = new Object2ObjectOpenHashMap(recipeMap.size());
        ObjectOpenHashSet tempSet = new ObjectOpenHashSet();
        for (Map.Entry<ComparableItemStackValidatedNBT, CrucibleRecipe> entry : recipeMap.entrySet()) {
            CrucibleRecipe tempRecipe = entry.getValue();
            ComparableItemStackValidatedNBT input = new ComparableItemStackValidatedNBT(tempRecipe.input);
            tempMap.put(input, tempRecipe);
            if (!FluidRegistry.LAVA.equals(tempRecipe.getOutput().getFluid())) continue;
            tempSet.add(input);
        }
        recipeMap.clear();
        recipeMap = tempMap;
        lavaSet.clear();
        lavaSet = tempSet;
    }

    public static CrucibleRecipe addRecipe(int energy, ItemStack input, FluidStack output) {
        if (input.func_190926_b() || output == null || output.amount <= 0 || energy <= 0 || CrucibleManager.recipeExists(input)) {
            return null;
        }
        ComparableItemStackValidatedNBT inputCrucible = new ComparableItemStackValidatedNBT(input);
        CrucibleRecipe recipe = new CrucibleRecipe(input, output, energy);
        recipeMap.put(inputCrucible, recipe);
        if (FluidRegistry.LAVA.equals(output.getFluid())) {
            lavaSet.add(inputCrucible);
        }
        return recipe;
    }

    public static CrucibleRecipe removeRecipe(ItemStack input) {
        ComparableItemStackValidatedNBT inputCrucible = new ComparableItemStackValidatedNBT(input);
        lavaSet.remove(inputCrucible);
        return recipeMap.remove(inputCrucible);
    }

    public static ComparableItemStackValidatedNBT convertInput(ItemStack stack) {
        return new ComparableItemStackValidatedNBT(stack);
    }

    public static class CrucibleRecipe {
        final ItemStack input;
        final FluidStack output;
        final int energy;

        CrucibleRecipe(ItemStack input, FluidStack output, int energy) {
            this.input = input;
            this.output = output;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public FluidStack getOutput() {
            return this.output;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

