/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.computer;

import com.google.common.collect.Maps;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorComputerPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import it.zerono.mods.zerocore.api.multiblock.MultiblockTileEntityBase;
import it.zerono.mods.zerocore.lib.compat.LuaHelper;
import it.zerono.mods.zerocore.lib.compat.computer.ComputerMethod;
import it.zerono.mods.zerocore.lib.compat.computer.MultiblockComputerPeripheral;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.Fluid;

public class ReactorComputerPeripheral
extends MultiblockComputerPeripheral<TileEntityReactorComputerPort> {
    public ReactorComputerPeripheral(@Nonnull TileEntityReactorComputerPort reactorComputerPort) {
        super((MultiblockTileEntityBase)reactorComputerPort);
    }

    public String getPeripheralStaticName() {
        return "extremereactor-reactorComputerPort";
    }

    public void populatePeripheralMethods(@Nonnull List<ComputerMethod> methods) {
        super.populatePeripheralMethods(methods);
        methods.add(new ComputerMethod("getEnergyStored", ReactorComputerPeripheral::getEnergyStored));
        methods.add(new ComputerMethod("getNumberOfControlRods", ReactorComputerPeripheral::getNumberOfControlRods));
        methods.add(new ComputerMethod("getActive", ReactorComputerPeripheral::getActive));
        methods.add(new ComputerMethod("getFuelTemperature", ReactorComputerPeripheral::getFuelTemperature));
        methods.add(new ComputerMethod("getCasingTemperature", ReactorComputerPeripheral::getCasingTemperature));
        methods.add(new ComputerMethod("getFuelAmount", ReactorComputerPeripheral::getFuelAmount));
        methods.add(new ComputerMethod("getWasteAmount", ReactorComputerPeripheral::getWasteAmount));
        methods.add(new ComputerMethod("getFuelAmountMax", ReactorComputerPeripheral::getFuelAmountMax));
        methods.add(new ComputerMethod("getControlRodName", ReactorComputerPeripheral::getControlRodName, 1));
        methods.add(new ComputerMethod("getControlRodLevel", ReactorComputerPeripheral::getControlRodLevel, 1));
        methods.add(new ComputerMethod("getEnergyProducedLastTick", ReactorComputerPeripheral::getEnergyProducedLastTick));
        methods.add(new ComputerMethod("getHotFluidProducedLastTick", ReactorComputerPeripheral::getHotFluidProducedLastTick));
        methods.add(new ComputerMethod("isActivelyCooled", ReactorComputerPeripheral::isActivelyCooled));
        methods.add(new ComputerMethod("getCoolantAmount", ReactorComputerPeripheral::getCoolantAmount));
        methods.add(new ComputerMethod("getCoolantAmountMax", ReactorComputerPeripheral::getCoolantAmountMax));
        methods.add(new ComputerMethod("getCoolantType", ReactorComputerPeripheral::getCoolantType));
        methods.add(new ComputerMethod("getHotFluidAmount", ReactorComputerPeripheral::getHotFluidAmount));
        methods.add(new ComputerMethod("getHotFluidAmountMax", ReactorComputerPeripheral::getHotFluidAmountMax));
        methods.add(new ComputerMethod("getHotFluidType", ReactorComputerPeripheral::getHotFluidType));
        methods.add(new ComputerMethod("getFuelReactivity", ReactorComputerPeripheral::getFuelReactivity));
        methods.add(new ComputerMethod("getFuelConsumedLastTick", ReactorComputerPeripheral::getFuelConsumedLastTick));
        methods.add(new ComputerMethod("getControlRodLocation", ReactorComputerPeripheral::getControlRodLocation, 1));
        methods.add(new ComputerMethod("getEnergyCapacity", ReactorComputerPeripheral::getEnergyCapacity));
        methods.add(new ComputerMethod("getControlRodsLevels", ReactorComputerPeripheral::getControlRodsLevels));
        methods.add(new ComputerMethod("setControlRodsLevels", ReactorComputerPeripheral::setControlRodsLevels, 1, true));
        methods.add(new ComputerMethod("getEnergyStats", ReactorComputerPeripheral::getEnergyStats));
        methods.add(new ComputerMethod("getFuelStats", ReactorComputerPeripheral::getFuelStats));
        methods.add(new ComputerMethod("getHotFluidStats", ReactorComputerPeripheral::getHotFluidStats));
        methods.add(new ComputerMethod("getCoolantFluidStats", ReactorComputerPeripheral::getCoolantFluidStats));
        methods.add(new ComputerMethod("setActive", ReactorComputerPeripheral::setActive, 1, true));
        methods.add(new ComputerMethod("setControlRodLevel", ReactorComputerPeripheral::setControlRodLevel, 2, true));
        methods.add(new ComputerMethod("setAllControlRodLevels", ReactorComputerPeripheral::setAllControlRodLevels, 1, true));
        methods.add(new ComputerMethod("setControlRodName", ReactorComputerPeripheral::setControlRodName, 2, true));
        methods.add(new ComputerMethod("doEjectWaste", ReactorComputerPeripheral::doEjectWaste, 0, true));
        methods.add(new ComputerMethod("doEjectFuel", ReactorComputerPeripheral::doEjectFuel, 0, true));
    }

    public static Object[] getEnergyStored(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getEnergyStored()};
    }

    public static Object[] getNumberOfControlRods(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getFuelRodCount()};
    }

    public static Object[] getActive(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getActive()};
    }

    public static Object[] getFuelTemperature(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{Float.valueOf(ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getFuelHeat())};
    }

    public static Object[] getCasingTemperature(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{Float.valueOf(ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getReactorHeat())};
    }

    public static Object[] getFuelAmount(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getFuelAmount()};
    }

    public static Object[] getWasteAmount(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getWasteAmount()};
    }

    public static Object[] getFuelAmountMax(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getCapacity()};
    }

    public static Object[] getControlRodName(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{ReactorComputerPeripheral.getControlRodByIndex(peripheral, LuaHelper.getIntFromArgs((Object[])arguments, (int)0)).getName()};
    }

    public static Object[] getControlRodLevel(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{ReactorComputerPeripheral.getControlRodByIndex(peripheral, LuaHelper.getIntFromArgs((Object[])arguments, (int)0)).getControlRodInsertion()};
    }

    public static Object[] getEnergyProducedLastTick(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{Float.valueOf(ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getEnergyGeneratedLastTick())};
    }

    public static Object[] getHotFluidProducedLastTick(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        MultiblockReactor reactor = ReactorComputerPeripheral.getReactorControllerOrFail(peripheral);
        return new Object[]{Float.valueOf(reactor.isPassivelyCooled() ? 0.0f : reactor.getEnergyGeneratedLastTick())};
    }

    public static Object[] isActivelyCooled(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{!ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).isPassivelyCooled()};
    }

    public static Object[] getCoolantAmount(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getCoolantContainer().getCoolantAmount()};
    }

    public static Object[] getCoolantAmountMax(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getCoolantContainer().getCapacity()};
    }

    public static Object[] getCoolantType(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        Fluid fluidType = ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getCoolantContainer().getCoolantType();
        return new Object[]{null == fluidType ? null : fluidType.getName()};
    }

    public static Object[] getHotFluidAmount(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getCoolantContainer().getVaporAmount()};
    }

    public static Object[] getHotFluidAmountMax(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getCoolantContainer().getCapacity()};
    }

    public static Object[] getHotFluidType(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        Fluid fluidType = ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getCoolantContainer().getVaporType();
        return new Object[]{null == fluidType ? null : fluidType.getName()};
    }

    public static Object[] getFuelReactivity(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{Float.valueOf(ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getFuelFertility() * 100.0f)};
    }

    public static Object[] getFuelConsumedLastTick(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{Float.valueOf(ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getFuelConsumedLastTick())};
    }

    public static Object[] getControlRodLocation(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        BlockPos reactorMinCoord = ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getMinimumCoord();
        BlockPos rodCoord = ReactorComputerPeripheral.getControlRodByIndex(peripheral, LuaHelper.getIntFromArgs((Object[])arguments, (int)0)).getWorldPosition();
        BlockPos coords = rodCoord.func_177973_b((Vec3i)reactorMinCoord);
        return new Object[]{coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()};
    }

    public static Object[] getEnergyCapacity(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getEnergyCapacity()};
    }

    public static Object[] getControlRodsLevels(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        MultiblockReactor reactor = ReactorComputerPeripheral.getReactorControllerOrFail(peripheral);
        HashMap levels = Maps.newHashMap();
        int controlRodsCount = reactor.getFuelRodCount();
        for (int idx = 0; idx < controlRodsCount; ++idx) {
            TileEntityReactorControlRod rod = reactor.getControlRodByIndex(idx);
            levels.put(idx, null != rod ? (int)rod.getControlRodInsertion() : -1);
        }
        return new Object[]{levels};
    }

    public static Object[] setControlRodsLevels(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        if (arguments[0] instanceof Map) {
            int idx;
            Map levels = (Map)arguments[0];
            MultiblockReactor reactor = ReactorComputerPeripheral.getReactorControllerOrFail(peripheral);
            int controlRodsCount = reactor.getFuelRodCount();
            if (controlRodsCount != levels.size()) {
                throw new Exception("Invalid levels count in a call to setControlRodsLevels()");
            }
            int[] newLevels = new int[controlRodsCount];
            for (idx = 0; idx < newLevels.length; ++idx) {
                double value;
                if (levels.containsKey(idx)) {
                    value = (Double)levels.get(idx);
                } else if (levels.containsKey(idx)) {
                    value = (Double)levels.get(idx);
                } else {
                    throw new Exception("Invalid table key in a call to setControlRodsLevels()");
                }
                newLevels[idx] = (int)Math.round(value);
                if (newLevels[idx] >= 0 && newLevels[idx] <= 100) continue;
                LuaHelper.raiseIllegalArgumentRange((int)idx, (int)0, (int)100);
            }
            for (idx = 0; idx < newLevels.length; ++idx) {
                TileEntityReactorControlRod rod = reactor.getControlRodByIndex(idx);
                if (null == rod) continue;
                rod.setControlRodInsertion((short)newLevels[idx]);
            }
            return null;
        }
        throw new Exception("Invalid parameter type in a call to setControlRodsLevels()");
    }

    public static Object[] getEnergyStats(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        MultiblockReactor reactor = ReactorComputerPeripheral.getReactorControllerOrFail(peripheral);
        HashMap stats = Maps.newHashMap();
        stats.put("energyStored", reactor.getEnergyStored());
        stats.put("energyCapacity", reactor.getEnergyCapacity());
        stats.put("energyProducedLastTick", Float.valueOf(reactor.getEnergyGeneratedLastTick()));
        return new Object[]{stats};
    }

    public static Object[] getFuelStats(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        MultiblockReactor reactor = ReactorComputerPeripheral.getReactorControllerOrFail(peripheral);
        HashMap stats = Maps.newHashMap();
        stats.put("fuelAmount", reactor.getFuelAmount());
        stats.put("fuelCapacity", reactor.getCapacity());
        stats.put("fuelTemperature", Float.valueOf(reactor.getFuelHeat()));
        stats.put("fuelConsumedLastTick", Float.valueOf(reactor.getFuelConsumedLastTick()));
        stats.put("fuelReactivity", Float.valueOf(reactor.getFuelFertility() * 100.0f));
        stats.put("wasteAmount", reactor.getWasteAmount());
        return new Object[]{stats};
    }

    public static Object[] getHotFluidStats(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        MultiblockReactor reactor = ReactorComputerPeripheral.getReactorControllerOrFail(peripheral);
        Fluid fluidType = reactor.getCoolantContainer().getVaporType();
        HashMap stats = Maps.newHashMap();
        stats.put("fluidType", null == fluidType ? null : fluidType.getName());
        stats.put("fluidAmount", reactor.getCoolantContainer().getVaporAmount());
        stats.put("fluidCapacity", reactor.getCoolantContainer().getCapacity());
        stats.put("fluidProducedLastTick", Float.valueOf(reactor.isPassivelyCooled() ? 0.0f : reactor.getEnergyGeneratedLastTick()));
        return new Object[]{stats};
    }

    public static Object[] getCoolantFluidStats(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        MultiblockReactor reactor = ReactorComputerPeripheral.getReactorControllerOrFail(peripheral);
        Fluid fluidType = reactor.getCoolantContainer().getCoolantType();
        HashMap stats = Maps.newHashMap();
        stats.put("fluidType", null == fluidType ? null : fluidType.getName());
        stats.put("fluidAmount", reactor.getCoolantContainer().getCoolantAmount());
        stats.put("fluidCapacity", reactor.getCoolantContainer().getCapacity());
        return new Object[]{stats};
    }

    public static Object[] setActive(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).setActive(LuaHelper.getBooleanFromArgs((Object[])arguments, (int)0));
        return null;
    }

    public static Object[] setControlRodLevel(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        ReactorComputerPeripheral.getControlRodByIndex(peripheral, LuaHelper.getIntFromArgs((Object[])arguments, (int)0)).setControlRodInsertion((short)LuaHelper.getIntFromArgs((Object[])arguments, (int)1, (int)0, (int)100));
        return null;
    }

    public static Object[] setAllControlRodLevels(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).setAllControlRodInsertionValues(LuaHelper.getIntFromArgs((Object[])arguments, (int)0, (int)0, (int)100));
        return null;
    }

    public static Object[] setControlRodName(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        ReactorComputerPeripheral.getControlRodByIndex(peripheral, LuaHelper.getIntFromArgs((Object[])arguments, (int)0)).setName(LuaHelper.getStringFromArgs((Object[])arguments, (int)1));
        return null;
    }

    public static Object[] doEjectWaste(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).ejectWaste(false, null);
        return null;
    }

    public static Object[] doEjectFuel(@Nonnull ReactorComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).ejectFuel(false, null);
        return null;
    }

    private static MultiblockReactor getReactorControllerOrFail(@Nonnull ReactorComputerPeripheral peripheral) throws Exception {
        if (!((TileEntityReactorComputerPort)peripheral.getMultiblockPart()).isConnected()) {
            throw new Exception("Unable to access reactor - port is not connected");
        }
        return ((TileEntityReactorComputerPort)peripheral.getMultiblockPart()).getReactorController();
    }

    private static TileEntityReactorControlRod getControlRodByIndex(@Nonnull ReactorComputerPeripheral peripheral, int index) throws Exception {
        TileEntityReactorControlRod controlRod = ReactorComputerPeripheral.getReactorControllerOrFail(peripheral).getControlRodByIndex(index);
        if (null == controlRod) {
            throw new IndexOutOfBoundsException(String.format("Invalid argument %d, control rod index is out of bounds", index));
        }
        return controlRod;
    }
}

