/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.util.IOrientable;
import appeng.decorative.solid.BlockQuartzPillar;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MetaRotation
implements IOrientable {
    private final IProperty<EnumFacing> facingProp;
    private final IBlockAccess w;
    private final BlockPos pos;

    public MetaRotation(IBlockAccess world, BlockPos pos, IProperty<EnumFacing> facingProp) {
        this.w = world;
        this.pos = pos;
        this.facingProp = facingProp;
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public EnumFacing getForward() {
        if (this.getUp().func_96559_d() == 0) {
            return EnumFacing.UP;
        }
        return EnumFacing.SOUTH;
    }

    @Override
    public EnumFacing getUp() {
        IBlockState state = this.w.func_180495_p(this.pos);
        if (this.facingProp != null) {
            return (EnumFacing)state.func_177229_b(this.facingProp);
        }
        EnumFacing.Axis a = (EnumFacing.Axis)state.func_177229_b(BlockQuartzPillar.AXIS_ORIENTATION);
        if (a == null) {
            a = EnumFacing.Axis.Y;
        }
        switch (a) {
            case X: {
                return EnumFacing.EAST;
            }
            case Z: {
                return EnumFacing.SOUTH;
            }
        }
        return EnumFacing.UP;
    }

    @Override
    public void setOrientation(EnumFacing forward, EnumFacing up) {
        if (this.w instanceof World) {
            if (this.facingProp != null) {
                ((World)this.w).func_175656_a(this.pos, this.w.func_180495_p(this.pos).func_177226_a(this.facingProp, (Comparable)up));
            } else {
                ((World)this.w).func_175656_a(this.pos, this.w.func_180495_p(this.pos).func_177226_a(BlockQuartzPillar.AXIS_ORIENTATION, (Comparable)up.func_176740_k()));
            }
        } else {
            throw new IllegalStateException(this.w.getClass().getName() + " received, expected World");
        }
    }
}

