/*
 * Decompiled with CFR 0.152.
 */
package info.pixelmon.repack.ninja.leaping.configurate.loader;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import info.pixelmon.repack.ninja.leaping.configurate.ConfigurationNode;
import info.pixelmon.repack.ninja.leaping.configurate.ConfigurationOptions;
import info.pixelmon.repack.ninja.leaping.configurate.loader.AtomicFiles;
import info.pixelmon.repack.ninja.leaping.configurate.loader.CommentHandler;
import info.pixelmon.repack.ninja.leaping.configurate.loader.CommentHandlers;
import info.pixelmon.repack.ninja.leaping.configurate.loader.ConfigurationLoader;
import info.pixelmon.repack.ninja.leaping.configurate.loader.HeaderMode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;

public abstract class AbstractConfigurationLoader<NodeType extends ConfigurationNode>
implements ConfigurationLoader<NodeType> {
    public static final String CONFIGURATE_LINE_SEPARATOR = "\n";
    protected static final Splitter LINE_SPLITTER = Splitter.on((String)"\n");
    protected static final String SYSTEM_LINE_SEPARATOR = System.lineSeparator();
    protected final Callable<BufferedReader> source;
    private final Callable<BufferedWriter> sink;
    private final CommentHandler[] commentHandlers;
    private final HeaderMode headerMode;
    private final ConfigurationOptions defaultOptions;

    protected AbstractConfigurationLoader(Builder<?> builder, CommentHandler[] commentHandlers) {
        this.source = builder.getSource();
        this.sink = builder.getSink();
        this.headerMode = builder.getHeaderMode();
        this.defaultOptions = builder.getDefaultOptions();
        this.commentHandlers = commentHandlers;
    }

    public CommentHandler getDefaultCommentHandler() {
        return this.commentHandlers[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NodeType load(ConfigurationOptions options) throws IOException {
        if (!this.canLoad()) {
            throw new IOException("No source present to read from!");
        }
        try (BufferedReader reader2222 = this.source.call();){
            String comment;
            if ((this.headerMode == HeaderMode.PRESERVE || this.headerMode == HeaderMode.NONE) && (comment = CommentHandlers.extractComment(reader2222, this.commentHandlers)) != null && comment.length() > 0) {
                options = options.setHeader(comment);
            }
            Object node = this.createEmptyNode(options);
            this.loadInternal(node, reader2222);
            Object NodeType = node;
            return NodeType;
        }
        catch (FileNotFoundException | NoSuchFileException reader2222) {
            return this.createEmptyNode(options);
        }
        catch (Exception e) {
            if (!(e instanceof IOException)) throw new IOException(e);
            throw (IOException)e;
        }
    }

    protected abstract void loadInternal(NodeType var1, BufferedReader var2) throws IOException;

    @Override
    public void save(ConfigurationNode node) throws IOException {
        if (!this.canSave()) {
            throw new IOException("No sink present to write to!");
        }
        try (Writer writer = this.sink.call();){
            String header;
            if (this.headerMode != HeaderMode.NONE && (header = node.getOptions().getHeader()) != null && !header.isEmpty()) {
                for (String line : this.getDefaultCommentHandler().toComment((Collection<String>)ImmutableList.copyOf((Iterable)LINE_SPLITTER.split((CharSequence)header)))) {
                    writer.write(line);
                    writer.write(SYSTEM_LINE_SEPARATOR);
                }
                writer.write(SYSTEM_LINE_SEPARATOR);
            }
            this.saveInternal(node, writer);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    protected abstract void saveInternal(ConfigurationNode var1, Writer var2) throws IOException;

    @Override
    public ConfigurationOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public boolean canLoad() {
        return this.source != null;
    }

    public boolean canSave() {
        return this.sink != null;
    }

    protected static abstract class Builder<T extends Builder> {
        protected HeaderMode headerMode = HeaderMode.PRESERVE;
        protected Callable<BufferedReader> source;
        protected Callable<BufferedWriter> sink;
        protected ConfigurationOptions defaultOptions = ConfigurationOptions.defaults();

        protected Builder() {
        }

        private T self() {
            return (T)this;
        }

        public T setFile(File file) {
            return this.setPath(file.toPath());
        }

        public T setPath(Path path) {
            Path absPath = Objects.requireNonNull(path, "path").toAbsolutePath();
            this.source = () -> Files.newBufferedReader(absPath, StandardCharsets.UTF_8);
            this.sink = AtomicFiles.createAtomicWriterFactory(absPath, StandardCharsets.UTF_8);
            return this.self();
        }

        public T setURL(URL url) {
            this.source = () -> new BufferedReader(new InputStreamReader(url.openConnection().getInputStream(), StandardCharsets.UTF_8));
            return this.self();
        }

        public T setSource(Callable<BufferedReader> source) {
            this.source = source;
            return this.self();
        }

        public T setSink(Callable<BufferedWriter> sink) {
            this.sink = sink;
            return this.self();
        }

        public Callable<BufferedReader> getSource() {
            return this.source;
        }

        public Callable<BufferedWriter> getSink() {
            return this.sink;
        }

        @Deprecated
        public T setPreservesHeader(boolean preservesHeader) {
            this.headerMode = preservesHeader ? HeaderMode.PRESERVE : HeaderMode.PRESET;
            return this.self();
        }

        @Deprecated
        public boolean preservesHeader() {
            return this.headerMode == HeaderMode.PRESERVE;
        }

        public T setHeaderMode(HeaderMode mode) {
            this.headerMode = mode;
            return this.self();
        }

        public HeaderMode getHeaderMode() {
            return this.headerMode;
        }

        public T setDefaultOptions(ConfigurationOptions defaultOptions) {
            this.defaultOptions = Objects.requireNonNull(defaultOptions, "defaultOptions");
            return this.self();
        }

        public ConfigurationOptions getDefaultOptions() {
            return this.defaultOptions;
        }

        public abstract AbstractConfigurationLoader build();
    }
}

