/*
 * Decompiled with CFR 0.152.
 */
package info.pixelmon.repack.ninja.leaping.configurate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import info.pixelmon.repack.ninja.leaping.configurate.ConfigValue;
import info.pixelmon.repack.ninja.leaping.configurate.ConfigurationNode;
import info.pixelmon.repack.ninja.leaping.configurate.ConfigurationOptions;
import info.pixelmon.repack.ninja.leaping.configurate.ListConfigValue;
import info.pixelmon.repack.ninja.leaping.configurate.MapConfigValue;
import info.pixelmon.repack.ninja.leaping.configurate.NullConfigValue;
import info.pixelmon.repack.ninja.leaping.configurate.ScalarConfigValue;
import info.pixelmon.repack.ninja.leaping.configurate.objectmapping.ObjectMappingException;
import info.pixelmon.repack.ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class SimpleConfigurationNode
implements ConfigurationNode {
    private final ConfigurationOptions options;
    volatile boolean attached;
    volatile Object key;
    private SimpleConfigurationNode parent;
    private volatile ConfigValue value;

    public static SimpleConfigurationNode root() {
        return SimpleConfigurationNode.root(ConfigurationOptions.defaults());
    }

    public static SimpleConfigurationNode root(ConfigurationOptions options) {
        return new SimpleConfigurationNode(null, null, options);
    }

    protected SimpleConfigurationNode(Object key, SimpleConfigurationNode parent, ConfigurationOptions options) {
        Preconditions.checkNotNull((Object)options, (Object)"options");
        this.key = key;
        if (parent == null) {
            this.attached = true;
        }
        this.options = options;
        this.parent = parent == null ? null : parent;
        this.value = new NullConfigValue(this);
    }

    @Override
    public Object getValue(Object def) {
        Object ret = this.value.getValue();
        return ret == null ? this.calculateDef(def) : ret;
    }

    @Override
    public Object getValue(Supplier<Object> defSupplier) {
        Object ret = this.value.getValue();
        return ret == null ? this.calculateDef(defSupplier.get()) : ret;
    }

    @Override
    public <T> T getValue(Function<Object, T> transformer, T def) {
        T ret = transformer.apply(this.getValue());
        return ret == null ? this.calculateDef(def) : ret;
    }

    @Override
    public <T> T getValue(Function<Object, T> transformer, Supplier<T> defSupplier) {
        T ret = transformer.apply(this.getValue());
        return ret == null ? this.calculateDef(defSupplier.get()) : ret;
    }

    private <T> T calculateDef(T defValue) {
        if (defValue != null && this.getOptions().shouldCopyDefaults()) {
            this.setValue(defValue);
        }
        return defValue;
    }

    @Override
    public <T> List<T> getList(Function<Object, T> transformer) {
        ImmutableList.Builder build = ImmutableList.builder();
        ConfigValue value = this.value;
        if (value instanceof ListConfigValue) {
            for (SimpleConfigurationNode o : value.iterateChildren()) {
                T transformed = transformer.apply(o.getValue());
                if (transformed == null) continue;
                build.add(transformed);
            }
        } else {
            T transformed = transformer.apply(value.getValue());
            if (transformed != null) {
                build.add(transformed);
            }
        }
        return build.build();
    }

    @Override
    public <T> List<T> getList(Function<Object, T> transformer, List<T> def) {
        List<T> ret = this.getList(transformer);
        return ret.isEmpty() ? this.calculateDef(def) : ret;
    }

    @Override
    public <T> List<T> getList(Function<Object, T> transformer, Supplier<List<T>> defSupplier) {
        List<T> ret = this.getList(transformer);
        return ret.isEmpty() ? this.calculateDef(defSupplier.get()) : ret;
    }

    @Override
    public <T> List<T> getList(TypeToken<T> type, List<T> def) throws ObjectMappingException {
        List<T> ret = this.getValue(new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type), def);
        return ret.isEmpty() ? this.calculateDef(def) : ret;
    }

    @Override
    public <T> List<T> getList(TypeToken<T> type, Supplier<List<T>> defSupplier) throws ObjectMappingException {
        List<T> ret = this.getValue(new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type), defSupplier);
        return ret.isEmpty() ? this.calculateDef(defSupplier.get()) : ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleConfigurationNode setValue(Object newValue) {
        if (newValue instanceof ConfigurationNode) {
            ConfigurationNode newNode = (ConfigurationNode)newValue;
            if (newNode.hasListChildren()) {
                this.attachIfNecessary();
                ListConfigValue newList = new ListConfigValue(this);
                ConfigurationNode configurationNode = newNode;
                synchronized (configurationNode) {
                    List<? extends ConfigurationNode> children = newNode.getChildrenList();
                    for (int i = 0; i < children.size(); ++i) {
                        SimpleConfigurationNode child = this.createNode(i);
                        child.attached = true;
                        newList.putChild(i, child);
                        child.setValue(children.get(i));
                    }
                }
                this.value = newList;
                return this;
            }
            if (newNode.hasMapChildren()) {
                this.attachIfNecessary();
                MapConfigValue newMap = new MapConfigValue(this);
                ConfigurationNode configurationNode = newNode;
                synchronized (configurationNode) {
                    Map<Object, ? extends ConfigurationNode> children = newNode.getChildrenMap();
                    for (Map.Entry<Object, ? extends ConfigurationNode> ent : children.entrySet()) {
                        SimpleConfigurationNode child = this.createNode(ent.getKey());
                        child.attached = true;
                        newMap.putChild(ent.getKey(), child);
                        child.setValue(ent.getValue());
                    }
                }
                this.value = newMap;
                return this;
            }
            newValue = newNode.getValue();
        }
        if (newValue == null) {
            if (this.parent == null) {
                this.clear();
            } else {
                this.parent.removeChild(this.key);
            }
            return this;
        }
        this.insertNewValue(newValue, false);
        return this;
    }

    @Override
    public <T> T getValue(TypeToken<T> type, T def) throws ObjectMappingException {
        Object value = this.getValue();
        if (value == null) {
            if (def != null && this.getOptions().shouldCopyDefaults()) {
                this.setValue(type, def);
            }
            return def;
        }
        TypeSerializer<T> serial = this.getOptions().getSerializers().get(type);
        if (serial == null) {
            if (type.getRawType().isInstance(value)) {
                return type.getRawType().cast(value);
            }
            if (def != null && this.getOptions().shouldCopyDefaults()) {
                this.setValue(type, def);
            }
            return def;
        }
        return serial.deserialize(type, this);
    }

    @Override
    public <T> T getValue(TypeToken<T> type, Supplier<T> defSupplier) throws ObjectMappingException {
        Object value = this.getValue();
        if (value == null) {
            T def = defSupplier.get();
            if (def != null && this.getOptions().shouldCopyDefaults()) {
                this.setValue(type, def);
            }
            return def;
        }
        TypeSerializer<T> serial = this.getOptions().getSerializers().get(type);
        if (serial == null) {
            if (type.getRawType().isInstance(value)) {
                return type.getRawType().cast(value);
            }
            T def = defSupplier.get();
            if (def != null && this.getOptions().shouldCopyDefaults()) {
                this.setValue(type, def);
            }
            return def;
        }
        return serial.deserialize(type, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNewValue(Object newValue, boolean onlyIfNull) {
        this.attachIfNecessary();
        SimpleConfigurationNode simpleConfigurationNode = this;
        synchronized (simpleConfigurationNode) {
            ConfigValue value;
            ConfigValue oldValue = value = this.value;
            if (onlyIfNull && !(oldValue instanceof NullConfigValue)) {
                return;
            }
            if (newValue instanceof Collection) {
                if (!(value instanceof ListConfigValue)) {
                    value = new ListConfigValue(this);
                }
            } else if (newValue instanceof Map) {
                if (!(value instanceof MapConfigValue)) {
                    value = new MapConfigValue(this);
                }
            } else if (!(value instanceof ScalarConfigValue)) {
                value = new ScalarConfigValue(this);
            }
            value.setValue(newValue);
            this.value = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationNode mergeValuesFrom(ConfigurationNode other) {
        if (other.hasMapChildren()) {
            SimpleConfigurationNode simpleConfigurationNode = this;
            synchronized (simpleConfigurationNode) {
                ConfigValue newValue;
                ConfigValue oldValue = newValue = this.value;
                if (!(oldValue instanceof MapConfigValue)) {
                    if (oldValue instanceof NullConfigValue) {
                        newValue = new MapConfigValue(this);
                    } else {
                        return this;
                    }
                }
                for (Map.Entry<Object, ? extends ConfigurationNode> ent : other.getChildrenMap().entrySet()) {
                    SimpleConfigurationNode newChild = this.createNode(ent.getKey());
                    newChild.attached = true;
                    newChild.setValue(ent.getValue());
                    SimpleConfigurationNode existing = newValue.putChildIfAbsent(ent.getKey(), newChild);
                    if (existing == null) continue;
                    existing.mergeValuesFrom(newChild);
                }
                this.value = newValue;
            }
        } else if (other.getValue() != null) {
            this.insertNewValue(other.getValue(), true);
        }
        return this;
    }

    @Override
    public SimpleConfigurationNode getNode(Object ... path) {
        SimpleConfigurationNode ret = this;
        for (Object el : path) {
            ret = ret.getChild(el, false);
        }
        return ret;
    }

    @Override
    public boolean isVirtual() {
        return !this.attached;
    }

    @Override
    public boolean hasListChildren() {
        return this.value instanceof ListConfigValue;
    }

    @Override
    public boolean hasMapChildren() {
        return this.value instanceof MapConfigValue;
    }

    public List<? extends SimpleConfigurationNode> getChildrenList() {
        ConfigValue value = this.value;
        return value instanceof ListConfigValue ? ImmutableList.copyOf((Collection)((ListConfigValue)value).values.get()) : Collections.emptyList();
    }

    public Map<Object, ? extends SimpleConfigurationNode> getChildrenMap() {
        ConfigValue value = this.value;
        return value instanceof MapConfigValue ? ImmutableMap.copyOf(((MapConfigValue)value).values) : Collections.emptyMap();
    }

    protected SimpleConfigurationNode getChild(Object key, boolean attach) {
        SimpleConfigurationNode child = this.value.getChild(key);
        if (child == null) {
            if (attach) {
                this.attachIfNecessary();
                child = this.createNode(key);
                SimpleConfigurationNode existingChild = this.value.putChildIfAbsent(key, child);
                if (existingChild != null) {
                    child = existingChild;
                } else {
                    this.attachChild(child);
                }
            } else {
                child = this.createNode(key);
            }
        }
        return child;
    }

    @Override
    public boolean removeChild(Object key) {
        return this.possiblyDetach(this.value.putChild(key, null)) != null;
    }

    private SimpleConfigurationNode possiblyDetach(SimpleConfigurationNode node) {
        if (node != null) {
            node.attached = false;
            node.clear();
        }
        return node;
    }

    @Override
    public SimpleConfigurationNode getAppendedNode() {
        return this.getChild(-1, false);
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public Object[] getPath() {
        LinkedList<Object> pathElements = new LinkedList<Object>();
        ConfigurationNode ptr = this;
        if (ptr.getParent() == null) {
            return new Object[]{this.getKey()};
        }
        do {
            pathElements.addFirst(ptr.getKey());
        } while ((ptr = ptr.getParent()).getParent() != null);
        return pathElements.toArray();
    }

    @Override
    public SimpleConfigurationNode getParent() {
        return this.parent;
    }

    @Override
    public ConfigurationOptions getOptions() {
        return this.options;
    }

    SimpleConfigurationNode getParentAttached() {
        SimpleConfigurationNode parent = this.parent;
        if (parent.isVirtual()) {
            parent = parent.getParentAttached().attachChildIfAbsent(parent);
        }
        this.parent = parent;
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleConfigurationNode attachChildIfAbsent(SimpleConfigurationNode child) {
        ConfigValue newValue;
        ConfigValue oldValue;
        if (this.isVirtual()) {
            throw new IllegalStateException("This parent is not currently attached. This is an internal state violation.");
        }
        if (!child.getParentAttached().equals(this)) {
            throw new IllegalStateException("Child " + child + " path is not a direct parent of me (" + this + "), cannot attach");
        }
        SimpleConfigurationNode simpleConfigurationNode = this;
        synchronized (simpleConfigurationNode) {
            SimpleConfigurationNode oldChild;
            newValue = oldValue = this.value;
            if (!(oldValue instanceof MapConfigValue)) {
                if (child.key instanceof Integer) {
                    if (oldValue instanceof NullConfigValue) {
                        newValue = new ListConfigValue(this);
                    } else if (!(oldValue instanceof ListConfigValue)) {
                        newValue = new ListConfigValue(this, oldValue.getValue());
                    }
                } else {
                    newValue = new MapConfigValue(this);
                }
            }
            if ((oldChild = newValue.putChildIfAbsent(child.key, child)) != null) {
                return oldChild;
            }
            this.value = newValue;
        }
        if (newValue != oldValue) {
            oldValue.clear();
        }
        child.attached = true;
        return child;
    }

    protected SimpleConfigurationNode createNode(Object path) {
        return new SimpleConfigurationNode(path, this, this.options);
    }

    protected void attachIfNecessary() {
        if (!this.attached) {
            this.getParentAttached().attachChild(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attachChild(SimpleConfigurationNode child) {
        ConfigValue newValue;
        ConfigValue oldValue;
        if (this.isVirtual()) {
            throw new IllegalStateException("This parent is not currently attached. This is an internal state violation.");
        }
        if (!child.getParentAttached().equals(this)) {
            throw new IllegalStateException("Child " + child + " path is not a direct parent of me (" + this + "), cannot attach");
        }
        SimpleConfigurationNode simpleConfigurationNode = this;
        synchronized (simpleConfigurationNode) {
            newValue = oldValue = this.value;
            if (!(oldValue instanceof MapConfigValue)) {
                if (child.key instanceof Integer) {
                    if (oldValue instanceof NullConfigValue) {
                        newValue = new ListConfigValue(this);
                    } else if (!(oldValue instanceof ListConfigValue)) {
                        newValue = new ListConfigValue(this, oldValue.getValue());
                    }
                } else {
                    newValue = new MapConfigValue(this);
                }
            }
            this.possiblyDetach(newValue.putChild(child.key, child));
            this.value = newValue;
        }
        if (newValue != oldValue) {
            oldValue.clear();
        }
        child.attached = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        SimpleConfigurationNode simpleConfigurationNode = this;
        synchronized (simpleConfigurationNode) {
            ConfigValue oldValue = this.value;
            this.value = new NullConfigValue(this);
            oldValue.clear();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleConfigurationNode)) {
            return false;
        }
        SimpleConfigurationNode that = (SimpleConfigurationNode)o;
        if (this.attached != that.attached) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (!this.options.equals(that.options)) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.options.hashCode();
        result = 31 * result + (this.attached ? 1 : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "SimpleConfigurationNode{options=" + this.options + ", attached=" + this.attached + ", key=" + this.key + ", parent=" + this.parent + ", value=" + this.value + '}';
    }
}

