/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.deepstorage;

import com.google.common.collect.ImmutableList;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class DeepStorage {
    private ArrayList<NBTTagCompound> archivedPokemon = new ArrayList();

    public DeepStorage(NBTTagCompound nbt) {
        int i = 0;
        while (nbt.func_74764_b("pokemon" + i)) {
            this.archivedPokemon.add(nbt.func_74775_l("pokemon" + i++));
        }
        this.clearDuplicates();
    }

    public boolean isEmpty() {
        return this.archivedPokemon.isEmpty();
    }

    public void write(File file) {
        block15: {
            try {
                file.createNewFile();
                NBTTagCompound deepStorageNBT = new NBTTagCompound();
                this.clearDuplicates();
                for (int i = 0; i < this.archivedPokemon.size(); ++i) {
                    deepStorageNBT.func_74782_a("pokemon" + i, (NBTBase)this.archivedPokemon.get(i));
                }
                try (DataOutputStream dataStream = new DataOutputStream(new FileOutputStream(file));){
                    CompressedStreamTools.func_74800_a((NBTTagCompound)deepStorageNBT, (DataOutput)dataStream);
                }
            }
            catch (IOException e) {
                if (!PixelmonConfig.printErrors) break block15;
                Pixelmon.LOGGER.error("Couldn't write deep store data file for " + file.getName(), (Throwable)e);
            }
        }
    }

    public void clearDuplicates() {
        ArrayList<Integer[]> ids = new ArrayList<Integer[]>();
        Iterator<NBTTagCompound> it = this.archivedPokemon.iterator();
        while (it.hasNext()) {
            NBTTagCompound nbt = it.next();
            int[] idraw = PixelmonMethods.getID(nbt);
            Integer[] id = new Integer[]{idraw[0], idraw[1]};
            if (ids.contains(id)) {
                it.remove();
                continue;
            }
            ids.add(id);
        }
    }

    public void put(NBTTagCompound nbt) {
        nbt.func_74757_a("isInRanch", false);
        this.archivedPokemon.add(nbt);
    }

    public ArrayList<NBTTagCompound> tryRetrieve() {
        ArrayList<NBTTagCompound> freedPokemon = new ArrayList<NBTTagCompound>();
        for (NBTTagCompound nbt : this.archivedPokemon) {
            if (!EnumPokemon.hasPokemonAnyCase(nbt.func_74779_i("Name"))) continue;
            freedPokemon.add(nbt);
        }
        this.archivedPokemon.removeAll(freedPokemon);
        return freedPokemon;
    }

    public ImmutableList<NBTTagCompound> getArchivedPokemon() {
        return ImmutableList.copyOf(this.archivedPokemon);
    }
}

