/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning.spawners;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.spawning.PixelmonBiomeDictionary;
import com.pixelmonmod.pixelmon.spawning.SpawnData;
import com.pixelmonmod.pixelmon.spawning.SpawnRegistry;
import com.pixelmonmod.pixelmon.spawning.spawners.EntityData;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerBase;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerTimed;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class SpawnerLegendary
extends SpawnerTimed {
    public SpawnerLegendary() {
        super(SpawnLocation.Legendary);
    }

    @Override
    protected boolean isDisabled() {
        return !PixelmonConfig.allowLegendariesSpawn;
    }

    @Override
    protected int getSpawnTickBase() {
        return PixelmonConfig.legendarySpawnTicks;
    }

    @Override
    protected double getSpawnTickVariance() {
        return 0.4;
    }

    @Override
    protected boolean rollSpawnChance() {
        return RandomHelper.getRandomChance(PixelmonConfig.legendarySpawnChance);
    }

    @Override
    public List<SpawnData> getEntityList(String biomeID) {
        return SpawnRegistry.getLegendarySpawnsForBiome(biomeID);
    }

    @Override
    public EntityData getRandomEntity(World world, Random rand, String biomeID, BlockPos pos, int level) {
        String pokemon;
        List<SpawnData> spawnData = this.getEntityList(biomeID);
        String string = pokemon = spawnData != null && !spawnData.isEmpty() ? SpawnerBase.getWeightedEntryFromList(world, spawnData) : null;
        if (pokemon == null) {
            return null;
        }
        Optional<BaseStats> stats = Entity3HasStats.getBaseStats(pokemon);
        return stats.isPresent() && world.func_82737_E() - stats.get().lastSpawn >= (long)PixelmonConfig.legendaryRepeatSpawnTicks ? new EntityData(pokemon, level) : null;
    }

    @Override
    public void modifyPokemon(EntityLiving pokemon, int cpXtmp, int cpZtmp) {
        EntityPixelmon pixelmon = (EntityPixelmon)pokemon;
        SpawnerLegendary.triggerLegendarySpawnEvent(pixelmon, cpXtmp, cpZtmp);
        pixelmon.legendaryTicks = 6000;
        pixelmon.baseStats.lastSpawn = pokemon.field_70170_p.func_82737_E();
    }

    @Override
    public SpawnLocation getActualSpawnLocation(EntityPixelmon pokemon) {
        SpawnLocation[] locations = pokemon.baseStats.spawnLocations;
        return locations.length == 0 ? SpawnLocation.Land : locations[RandomHelper.getRandomNumberBetween(0, locations.length - 1)];
    }

    private static void triggerLegendarySpawnEvent(EntityPixelmon pokemon, int x, int y) {
        if (PixelmonConfig.doLegendaryEvent) {
            Biome b = pokemon.field_70170_p.func_180494_b(new BlockPos(x, 0, y));
            pokemon.field_70170_p.func_73046_m().func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation("chat.type.announcement", new Object[]{TextFormatting.LIGHT_PURPLE + "Pixelmon" + TextFormatting.RESET, TextFormatting.GREEN + I18n.func_74837_a((String)"spawn.legendarymessage", (Object[])new Object[]{pokemon.getLocalizedName(), PixelmonBiomeDictionary.getBiomeInfo((Biome)b).biomeEnglishName})}));
            Pixelmon.LOGGER.info("LEGENDARY SPAWN - X: " + x + " Y: " + 0 + " Z: " + y);
            Pixelmon.LOGGER.info("LEGENDARY SPAWN - X: " + pokemon.func_180425_c().func_177958_n() + " Y: " + pokemon.func_180425_c().func_177956_o() + " Z: " + pokemon.func_180425_c().func_177952_p());
        }
    }

    @Override
    public int getMaxNum() {
        return 1;
    }
}

