/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.blocks.IPokemonOwner;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity6CanBattle;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumAggression;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.AIHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Aggression;
import java.util.HashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class Entity7HasAI
extends Entity6CanBattle {
    private int lastOwnerX;
    private int lastOwnerY;
    private int lastOwnerZ;
    private BlockPos idleSpot;
    public IPokemonOwner blockOwner = null;
    public EnumAggression aggression;
    public int aggressionTimer = 0;
    protected AIHelper aiHelper;
    public int moveIndex = -1;
    public int targetX;
    public int targetY;
    public int targetZ;
    public EnumFacing targetSide;

    public AIHelper getAIHelper() {
        if (this.aiHelper == null) {
            this.aiHelper = new AIHelper(this.getPokemonName(), this, this.field_70714_bg);
        }
        return this.aiHelper;
    }

    public Entity7HasAI(World par1World) {
        super(par1World);
    }

    @Override
    protected void init(String name) {
        super.init(name);
        int r = this.field_70146_Z.nextInt(100) + 1;
        this.lastOwnerZ = 0;
        this.lastOwnerY = 0;
        this.lastOwnerX = 0;
        this.idleSpot = null;
        Aggression a = this.baseStats.aggression;
        if (this.func_70902_q() != null) {
            this.aggression = EnumAggression.passive;
        }
        if (this.aggression == null) {
            if (a == null) {
                this.aggression = EnumAggression.passive;
                return;
            }
            this.aggression = r < a.timid ? EnumAggression.timid : (r < a.timid + a.passive ? EnumAggression.passive : (r < a.timid + a.passive + a.aggressive ? EnumAggression.aggressive : EnumAggression.passive));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.aggression == null) {
            this.aggression = EnumAggression.passive;
        }
        nbt.func_74768_a("Aggression", this.aggression.index);
    }

    @Override
    public void getNBTTags(HashMap<String, Class> tags) {
        super.getNBTTags(tags);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.aggression = EnumAggression.getAggression(nbt.func_74762_e("Aggression"));
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.aiHelper == null && this.baseStats != null) {
            this.resetAI();
        }
        if (this.aggressionTimer > 0 && this.battleController == null) {
            --this.aggressionTimer;
        }
    }

    public void resetAI() {
        this.aiHelper = new AIHelper(this.getPokemonName(), this, this.field_70714_bg);
    }

    @Override
    public void func_191986_a(float strafe, float up, float forward) {
        SpawnLocation location = this.getSpawnLocation();
        if (location == SpawnLocation.AirPersistent) {
            this.field_70181_x = 0.0;
        }
        super.func_191986_a(strafe, up, forward);
        if (location == SpawnLocation.AirPersistent) {
            this.field_70181_x = 0.0;
        }
        if (location == SpawnLocation.Air && this.isFlying) {
            this.field_70181_x -= 0.01;
        }
    }

    public void setIdleSpot(BlockPos coords) {
        this.idleSpot = coords;
    }

    public BlockPos getIdleSpot() {
        return this.idleSpot;
    }

    public void updateOwnerCoords() {
        this.lastOwnerX = (int)(this.func_70902_q().field_70165_t + 0.5);
        this.lastOwnerY = (int)(this.func_70902_q().field_70163_u + 0.5);
        this.lastOwnerZ = (int)(this.func_70902_q().field_70161_v + 0.5);
    }

    public int getLastOwnerX() {
        return this.lastOwnerX;
    }

    public int getLastOwnerY() {
        return this.lastOwnerY;
    }

    public int getLastOwnerZ() {
        return this.lastOwnerZ;
    }

    public void func_70624_b(EntityLivingBase entity) {
        this.moveIndex = -1;
        super.func_70624_b(entity);
    }

    public void setAttackTarget(EntityLivingBase entity, int moveIndex) {
        this.func_70624_b(entity);
        this.moveIndex = moveIndex;
    }

    public void setBlockTarget(int x, int y, int z, EnumFacing side, int moveIndex) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.targetSide = side;
        this.moveIndex = moveIndex;
    }
}

