/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawner;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.spawning.PlayerTrackingSpawner;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerBoss;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerNPC;
import java.util.ArrayList;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class Spawning
extends PixelmonCommand {
    public static final String COMMAND_NAME = "spawning";

    public Spawning() {
        super(new PixelmonCommand[0]);
    }

    public String func_71517_b() {
        return COMMAND_NAME;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/spawning [off | normal | beta | diagnose]";
    }

    public int func_82362_a() {
        return 4;
    }

    @Override
    protected void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            if (PixelmonSpawning.coordinator != null && PixelmonSpawning.coordinator.getActive()) {
                this.sendMessage(sender, "Spawner: Beta.", new Object[0]);
            } else if (!PixelmonSpawner.spawners.isEmpty()) {
                this.sendMessage(sender, "Spawner: Normal.", new Object[0]);
            } else {
                this.sendMessage(sender, "Spawner: Off", new Object[0]);
            }
        } else {
            String option = args[0].toLowerCase();
            if (option.equals("off")) {
                if (PixelmonSpawning.coordinator != null) {
                    PixelmonSpawning.coordinator.deactivate();
                }
                PixelmonSpawner.spawners.clear();
                this.sendMessage(sender, "All spawning has been turned off.", new Object[0]);
            } else if (option.equals("normal")) {
                if (PixelmonSpawning.coordinator != null) {
                    PixelmonSpawning.coordinator.deactivate();
                }
                PixelmonSpawner.addNormalSpawners();
                this.sendMessage(sender, "Normal spawning has been restored.", new Object[0]);
            } else if (option.equals("beta")) {
                PixelmonSpawner.spawners.removeIf(spawner -> !(spawner instanceof SpawnerNPC) && !(spawner instanceof SpawnerBoss));
                if (PixelmonSpawning.coordinator != null) {
                    PixelmonSpawning.coordinator.deactivate();
                }
                PixelmonSpawning.startTrackingSpawner();
                this.sendMessage(sender, "Beta spawning system has been engaged.", new Object[0]);
            } else if (option.equals("diagnose")) {
                boolean spawnerActive = PixelmonSpawning.coordinator != null && PixelmonSpawning.coordinator.getActive();
                ChatHandler.sendChat(sender, new TextComponentTranslation(TextFormatting.GRAY + "Better Spawner: " + (spawnerActive ? TextFormatting.GREEN + "Active." : TextFormatting.RED + "Inactive."), new Object[0]));
                if (spawnerActive) {
                    int spawnerCount = PixelmonSpawning.coordinator.spawners.size();
                    this.sendMessage(sender, TextFormatting.GRAY + "Spawner count: " + TextFormatting.YELLOW + spawnerCount, new Object[0]);
                    if (spawnerCount > 0) {
                        ArrayList<String> summaryMessages = new ArrayList<String>();
                        for (AbstractSpawner spawner2 : PixelmonSpawning.coordinator.spawners) {
                            double expectedSeconds;
                            if (!(spawner2 instanceof PlayerTrackingSpawner)) continue;
                            String message = "";
                            PlayerTrackingSpawner pts = (PlayerTrackingSpawner)spawner2;
                            EntityPlayerMP player = pts.getTrackedPlayer();
                            message = player == null ? TextFormatting.RED + "OFFLINE PLAYER " + TextFormatting.GRAY + "(" : TextFormatting.YELLOW + player.func_70005_c_() + " (";
                            double percentage = (double)pts.spawned.size() / (double)pts.capacity * 100.0;
                            String strPercentage = String.format("%.1f", percentage) + "%";
                            strPercentage = percentage == 100.0 || percentage == 0.0 ? TextFormatting.RED + strPercentage : TextFormatting.YELLOW + strPercentage;
                            message = message + strPercentage + TextFormatting.GRAY + ") - Last Cycle: ";
                            long timeSinceLastCycle = System.currentTimeMillis() - pts.lastCycleTime;
                            double seconds = (double)timeSinceLastCycle / 1000.0;
                            message = seconds > (expectedSeconds = (double)(pts.spawnFrequency / 60.0f)) * 60.0 ? message + TextFormatting.RED + String.format("%.1f", seconds) + "s" : (seconds > expectedSeconds * 10.0 ? message + TextFormatting.YELLOW + String.format("%.1f", seconds) + "s" : message + TextFormatting.GREEN + String.format("%.1f", seconds) + "s");
                            message = message + TextFormatting.GRAY + " - Last Spawn: ";
                            long timeSinceLastSpawn = System.currentTimeMillis() - pts.lastSpawnTime;
                            seconds = (double)timeSinceLastSpawn / 1000.0;
                            String time = String.format("%.1f", seconds) + "s";
                            message = seconds > expectedSeconds * 60.0 ? message + TextFormatting.RED + time : (seconds > expectedSeconds * 10.0 ? message + TextFormatting.YELLOW + time : message + TextFormatting.GREEN + time);
                            summaryMessages.add(message);
                        }
                        for (String message : summaryMessages) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(message));
                        }
                    }
                }
            }
        }
    }
}

