/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.util.helpers.SpriteHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;

public class GivePixelSprite
extends PixelmonCommand {
    public GivePixelSprite() {
        super(new PixelmonCommand[0]);
    }

    public String func_71517_b() {
        return "givepixelsprite";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/givepixelsprite <pokemon name> [form] OR /givepixelsprite <pixelmon:sprites/pokemon/001>";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayerMP)) {
            return;
        }
        if (args.length == 0 || args.length > 2) {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        ItemStack itemStack = new ItemStack(PixelmonItems.itemPixelmonSprite);
        NBTTagCompound tagCompound = new NBTTagCompound();
        itemStack.func_77982_d(tagCompound);
        if (args[0].contains(":")) {
            tagCompound.func_74778_a("SpriteName", args[0]);
        } else {
            EnumPokemon pokemon = EnumPokemon.getFromNameAnyCase(args[0]);
            if (pokemon == null) {
                player.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
                return;
            }
            int form = 0;
            form = args.length == 2 ? GivePixelSprite.func_175755_a((String)args[1]) : (int)pokemon.getFormEnum(form).getForm();
            Optional<BaseStats> stats = Entity3HasStats.getBaseStats(pokemon.name);
            if (!stats.isPresent()) {
                player.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
                return;
            }
            String tag = "pixelmon:sprites/pokemon/" + String.format("%03d", stats.get().nationalPokedexNumber);
            if (form != -1) {
                tag = tag + SpriteHelper.getSpriteExtra(stats.get().pixelmonName, form);
            }
            tagCompound.func_74778_a("SpriteName", tag);
            NBTTagCompound display = new NBTTagCompound();
            display.func_74778_a("Name", Entity1Base.getLocalizedName(pokemon.name) + " " + I18n.func_74838_a((String)"item.pixelmon_sprite.name"));
            tagCompound.func_74782_a("display", (NBTBase)display);
        }
        player.field_71071_by.func_70441_a(itemStack);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        return args.length == 1 ? this.tabCompletePokemon(args) : Collections.emptyList();
    }
}

