/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.storage.AsyncStorageWrapper;
import com.pixelmonmod.pixelmon.storage.DatabaseStorage;
import com.pixelmonmod.pixelmon.storage.FileStorage;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class DumpFromDB
extends PixelmonCommand {
    public DumpFromDB() {
        super(new PixelmonCommand[0]);
    }

    public String func_71517_b() {
        return "dumpfromdb";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/dumpFromDB";
    }

    public int func_82362_a() {
        return 4;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (PixelmonConfig.saveToDatabase) {
            this.sendMessage(sender, "pixelmon.command.copyToDB.disabled", new Object[0]);
            return;
        }
        if (PixelmonStorage.storageAdapter instanceof AsyncStorageWrapper) {
            ((AsyncStorageWrapper)PixelmonStorage.storageAdapter).flush();
        }
        FileStorage fileStorage = new FileStorage();
        DatabaseStorage databaseStorage = new DatabaseStorage();
        if (!databaseStorage.checkConnection()) {
            this.sendMessage(sender, "pixelmon.command.copyToDB.error", new Object[0]);
        }
        ArrayList list = Lists.newArrayList();
        try {
            PreparedStatement statement = databaseStorage.connection.prepareStatement("SELECT UUIDMost, UUIDLeast FROM PLAYERDATA");
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                long most = rs.getLong("UUIDMost");
                long least = rs.getLong("UUIDLeast");
                UUID uuid = new UUID(most, least);
                list.add(uuid);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        for (UUID uuid : list) {
            try {
                NBTTagCompound playerData = databaseStorage.readPlayerData(uuid);
                if (playerData != null) {
                    Pixelmon.LOGGER.info("DumpFromDB writing playerdata for " + uuid);
                    fileStorage.writePlayerData(uuid, playerData);
                } else {
                    Pixelmon.LOGGER.info("DumpFromDB error copying playerdata for " + uuid);
                }
                NBTTagCompound computerData = databaseStorage.readComputerData(uuid);
                if (computerData != null) {
                    Pixelmon.LOGGER.info("DumpFromDB writing computerdata for " + uuid);
                    fileStorage.writeComputerData(uuid, computerData);
                    continue;
                }
                Pixelmon.LOGGER.info("DumpFromDB computerdata not found for " + uuid);
            }
            catch (Exception e) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Error reading player " + uuid));
                e.printStackTrace();
            }
        }
    }
}

