/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class BankTransfer
extends PixelmonCommand {
    public BankTransfer() {
        super(new PixelmonCommand[0]);
    }

    public String func_71517_b() {
        return "transfer";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/transfer <player> <money>";
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2 || args.length > 3) {
            CommandChatHandler.sendChat(sender, "pixelmon.command.general.invalid", new Object[0]);
            CommandChatHandler.sendChat(sender, this.func_71518_a(sender), new Object[0]);
            return;
        }
        EntityPlayerMP user = this.getPlayer(sender, sender.func_70005_c_());
        if (user == null) {
            throw new PlayerNotFoundException(sender.func_70005_c_());
        }
        int amount = 0;
        try {
            amount = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (amount <= 0) {
            this.sendMessage(sender, "pixelmon.command.general.invalid", new Object[0]);
            this.sendMessage(sender, this.func_71518_a(sender), new Object[0]);
            return;
        }
        EntityPlayerMP target = this.getPlayer(sender, args[0]);
        if (target == null) {
            throw new PlayerNotFoundException(args[0]);
        }
        if (user == target) {
            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.transfer.sameplayer", new Object[0]);
            return;
        }
        PlayerStorage userStorage = this.getPlayerStorage(user);
        PlayerStorage targetStorage = this.getPlayerStorage(target);
        if (userStorage != null && targetStorage != null) {
            if (userStorage.getCurrency() < amount) {
                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.transfer.notenoughmoney", new Object[0]);
                return;
            }
            int beforeCurrency = targetStorage.getCurrency();
            targetStorage.addCurrency(amount);
            int currencyDifference = targetStorage.getCurrency() - beforeCurrency;
            userStorage.addCurrency(-1 * currencyDifference);
            ITextComponent targetName = target.func_145748_c_();
            if (currencyDifference == 0) {
                if (amount > 0) {
                    this.sendMessage(sender, "pixelmon.command.givemoney.moneylimit", targetName);
                } else {
                    this.sendMessage(sender, "pixelmon.command.givemoney.nomoney", targetName);
                }
            } else {
                String currencyString = Integer.toString(currencyDifference);
                BankTransfer.func_152374_a((ICommandSender)sender, (ICommand)this, (int)0, (String)"pixelmon.command.transfer.notifytransfer", (Object[])new Object[]{sender.func_70005_c_(), currencyString, targetName});
                this.sendMessage(sender, "pixelmon.command.transfer.transferred", currencyString, targetName);
                this.sendMessage((ICommandSender)target, "pixelmon.command.transfer.received", user.func_145748_c_(), currencyString);
            }
        } else {
            this.sendMessage(sender, "pixelmon.command.general.invalidplayer", new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length != 1 ? Collections.emptyList() : this.tabCompleteUsernames(args);
    }
}

