/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiTrainerEditor;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ClearTrainerPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTrainerPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdateEditedPokemon;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.items.ItemNPCEditor;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class UpdateTrainerPokemon
extends UpdateEditedPokemon {
    int trainerID;

    public UpdateTrainerPokemon() {
    }

    public UpdateTrainerPokemon(PixelmonData data) {
        super(data);
        this.trainerID = GuiTrainerEditor.currentTrainerID;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.trainerID);
        super.toBytes(buffer);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        this.trainerID = buffer.readInt();
        super.fromBytes(buffer);
    }

    public static class Handler
    implements IMessageHandler<UpdateTrainerPokemon, IMessage> {
        public IMessage onMessage(UpdateTrainerPokemon message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (!ItemNPCEditor.checkPermission(player)) {
                return null;
            }
            Optional<NPCTrainer> entityNPCOptional = EntityNPC.locateNPCServer(player.field_70170_p, message.trainerID, NPCTrainer.class);
            if (!entityNPCOptional.isPresent()) {
                return null;
            }
            NPCTrainer t = entityNPCOptional.get();
            PlayerStorage storage = t.getPokemonStorage();
            NBTTagCompound tag = UpdateEditedPokemon.updatePokemon(message, player, storage);
            if (tag != null) {
                t.updateLvl();
                Pixelmon.network.sendTo((IMessage)new ClearTrainerPokemon(), player);
                for (int i = 0; i < storage.count(); ++i) {
                    Pixelmon.network.sendTo((IMessage)new StoreTrainerPokemon(new PixelmonData(storage.getList()[i])), player);
                }
            }
            return null;
        }
    }
}

