/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.client.gui.npc.ClientShopItem;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiChattingNPC;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiShopContainer;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiShopkeeper;
import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItemWithVariation;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopkeeperChat;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SetNPCData
implements IMessage {
    SetTrainerData data;
    EnumNPCType npcType;
    ArrayList<String> chatPages;
    String name;
    ArrayList<ShopItemWithVariation> buyList;
    ArrayList<ShopItemWithVariation> sellList;
    ArrayList<ClientShopItem> clientBuyList;
    ArrayList<ClientShopItem> clientSellList;
    ShopkeeperChat skChat;

    public SetNPCData() {
    }

    public SetNPCData(String name, ArrayList<String> chatPages) {
        this.name = name;
        this.npcType = EnumNPCType.ChattingNPC;
        this.chatPages = chatPages;
    }

    public SetNPCData(String name, ShopkeeperChat chat, ArrayList<ShopItemWithVariation> buyList, ArrayList<ShopItemWithVariation> sellList2) {
        this.name = name;
        this.npcType = EnumNPCType.Shopkeeper;
        this.skChat = chat;
        this.buyList = buyList;
        this.sellList = sellList2;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeShort(this.npcType.ordinal());
        switch (this.npcType) {
            case ChattingNPC: {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
                buffer.writeShort(this.chatPages.size());
                for (String page : this.chatPages) {
                    ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)page);
                }
                break;
            }
            case Shopkeeper: {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
                this.skChat.writeToBuffer(buffer);
                buffer.writeShort(this.buyList.size());
                for (ShopItemWithVariation item : this.buyList) {
                    item.writeToBuffer(buffer);
                }
                buffer.writeShort(this.sellList.size());
                for (ShopItemWithVariation item : this.sellList) {
                    item.writeToBuffer(buffer);
                }
                break;
            }
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.npcType = EnumNPCType.getFromOrdinal(buffer.readShort());
        switch (this.npcType) {
            case ChattingNPC: {
                this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                this.chatPages = new ArrayList();
                int numPages = buffer.readShort();
                for (int i = 0; i < numPages; ++i) {
                    this.chatPages.add(ByteBufUtils.readUTF8String((ByteBuf)buffer));
                }
                break;
            }
            case Shopkeeper: {
                int i;
                this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                this.skChat = ShopkeeperChat.loadFromBuffer(buffer);
                int numItems = buffer.readShort();
                this.clientBuyList = new ArrayList();
                for (i = 0; i < numItems; ++i) {
                    this.clientBuyList.add(ClientShopItem.fromBuffer(buffer));
                }
                numItems = buffer.readShort();
                this.clientSellList = new ArrayList();
                for (i = 0; i < numItems; ++i) {
                    this.clientSellList.add(ClientShopItem.fromBuffer(buffer));
                }
                break;
            }
        }
    }

    public static class Handler
    implements IMessageHandler<SetNPCData, IMessage> {
        public IMessage onMessage(SetNPCData message, MessageContext ctx) {
            switch (message.npcType) {
                case ChattingNPC: {
                    GuiChattingNPC.name = message.name;
                    GuiChattingNPC.chatPages = message.chatPages;
                    break;
                }
                case Shopkeeper: {
                    GuiShopkeeper.name = message.name;
                    GuiShopkeeper.chat = message.skChat;
                    GuiShopContainer.buyItems = message.clientBuyList;
                    GuiShopContainer.sellItems = message.clientSellList;
                    break;
                }
            }
            return null;
        }
    }
}

