/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.customOverlays;

import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomNoticeOverlay;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.GraphicDisplayTypes;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.GraphicTypes;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CustomNoticePacket
implements IMessage {
    boolean enabled = true;
    Collection<String> lines;
    GraphicTypes graphicType = null;
    GraphicDisplayTypes graphicDisplayType = null;
    String itemName = null;
    EnumPokemon pokemon;

    public CustomNoticePacket() {
    }

    public CustomNoticePacket(Collection<String> lines) {
        this.lines = lines;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setPokemonSprite(EnumPokemon pokemon, GraphicDisplayTypes displayType) {
        this.graphicType = GraphicTypes.PokemonSprite;
        this.pokemon = pokemon;
        this.graphicDisplayType = displayType;
    }

    public void setPokemon3D(EnumPokemon pokemon, GraphicDisplayTypes displayType) {
        this.graphicType = GraphicTypes.Pokemon3D;
        this.pokemon = pokemon;
        this.graphicDisplayType = displayType;
    }

    public void setItemSprite(String itemName, GraphicDisplayTypes displayType) {
        this.graphicType = GraphicTypes.ItemSprite;
        this.itemName = itemName;
        this.graphicDisplayType = displayType;
    }

    public void setItem3D(String itemName, GraphicDisplayTypes displayType) {
        this.graphicType = GraphicTypes.Item3D;
        this.itemName = itemName;
        this.graphicDisplayType = displayType;
    }

    public void fromBytes(ByteBuf buf) {
        this.enabled = buf.readBoolean();
        if (!this.enabled) {
            return;
        }
        int lineAmount = buf.readByte();
        this.lines = new ArrayList<String>(lineAmount);
        for (int i = 0; i < lineAmount; ++i) {
            this.lines.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        if (buf.readBoolean()) {
            this.graphicType = GraphicTypes.values()[buf.readByte()];
            this.graphicDisplayType = GraphicDisplayTypes.values()[buf.readByte()];
            switch (this.graphicType) {
                case PokemonSprite: 
                case Pokemon3D: {
                    this.pokemon = EnumPokemon.getFromName(ByteBufUtils.readUTF8String((ByteBuf)buf)).get();
                    break;
                }
                case ItemSprite: 
                case Item3D: {
                    this.itemName = ByteBufUtils.readUTF8String((ByteBuf)buf);
                }
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.enabled);
        if (!this.enabled) {
            return;
        }
        buf.writeByte(this.lines.size());
        for (String line : this.lines) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)line);
        }
        buf.writeBoolean(this.graphicType != null);
        if (this.graphicType != null) {
            buf.writeByte(this.graphicType.ordinal());
            buf.writeByte(this.graphicDisplayType.ordinal());
            switch (this.graphicType) {
                case PokemonSprite: 
                case Pokemon3D: {
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.pokemon.name);
                    break;
                }
                case ItemSprite: 
                case Item3D: {
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.itemName);
                }
            }
        }
    }

    public static class Handler
    implements IMessageHandler<CustomNoticePacket, IMessage> {
        public IMessage onMessage(CustomNoticePacket message, MessageContext ctx) {
            if (!message.enabled) {
                CustomNoticeOverlay.setEnabled(false);
                return null;
            }
            CustomNoticeOverlay.resetNotice();
            CustomNoticeOverlay.populate(message.lines);
            if (message.graphicType != null) {
                switch (message.graphicType) {
                    case PokemonSprite: {
                        CustomNoticeOverlay.setPokemonSprite(message.pokemon, message.graphicDisplayType);
                        break;
                    }
                    case Pokemon3D: {
                        CustomNoticeOverlay.setPokemon3D(message.pokemon, message.graphicDisplayType);
                        break;
                    }
                    case ItemSprite: {
                        CustomNoticeOverlay.setItemSprite(message.itemName, message.graphicDisplayType);
                        break;
                    }
                    case Item3D: {
                        CustomNoticeOverlay.setItem3D(message.itemName, message.graphicDisplayType);
                    }
                }
            }
            CustomNoticeOverlay.setEnabled(true);
            return null;
        }
    }
}

