/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.camera;

import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.items.ItemPixelmonSprite;
import com.pixelmonmod.pixelmon.sounds.PixelSounds;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ItemCameraPacket
implements IMessage {
    public int entityId;

    public ItemCameraPacket() {
    }

    public ItemCameraPacket(int entityID) {
        this.entityId = entityID;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.entityId, (int)4);
    }

    public static class Handler
    implements IMessageHandler<ItemCameraPacket, IMessage> {
        public IMessage onMessage(ItemCameraPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            EntityPixelmon pixelmon = (EntityPixelmon)ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.entityId);
            if (pixelmon != null) {
                if (!PixelmonConfig.allowMultiplePhotosOfSamePokemon && pixelmon.cameraCapturedPlayers.contains(player.func_110124_au())) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("camera.error.samepokemon", new Object[]{Entity1Base.getLocalizedName(pixelmon.baseStats.pixelmonName)}));
                } else if (player.field_71071_by.func_174925_a(PixelmonItems.filmItem, 0, 1, null) == 1) {
                    if (!PixelmonConfig.allowMultiplePhotosOfSamePokemon) {
                        pixelmon.cameraCapturedPlayers.add(player.func_110124_au());
                    }
                    player.field_71071_by.func_70441_a(ItemPixelmonSprite.getPhoto(pixelmon));
                    pixelmon.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PixelSounds.cameraShutter, SoundCategory.AMBIENT, 1.0f, 1.0f);
                }
            }
            return null;
        }
    }
}

