/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.client.gui.GuiPixelmonOverlay;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.items.ItemPokeball;
import com.pixelmonmod.pixelmon.storage.PCClientStorage;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ServerConfigList
implements IMessage {
    int computerBoxCount = PlayerComputerStorage.boxCount = PixelmonConfig.computerBoxes;
    boolean allowCapturingOutsideBattle = ItemPokeball.allowCapturingOutsideBattle = PixelmonConfig.allowCapturingOutsideBattle;
    public int maxLevel = PixelmonConfig.maxLevel;
    public float ridingSpeedMultiplier = PixelmonConfig.ridingSpeedMultiplier;
    public boolean afkHandlerOn = PixelmonConfig.afkHandlerOn;
    public int afkTimerActivateSeconds = PixelmonConfig.afkTimerActivateSeconds;

    public void fromBytes(ByteBuf buf) {
        this.computerBoxCount = buf.readInt();
        this.allowCapturingOutsideBattle = buf.readBoolean();
        this.maxLevel = buf.readInt();
        this.ridingSpeedMultiplier = buf.readFloat();
        this.afkHandlerOn = buf.readBoolean();
        this.afkTimerActivateSeconds = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.computerBoxCount);
        buf.writeBoolean(this.allowCapturingOutsideBattle);
        buf.writeInt(this.maxLevel);
        buf.writeFloat(this.ridingSpeedMultiplier);
        buf.writeBoolean(this.afkHandlerOn);
        buf.writeInt(this.afkTimerActivateSeconds);
    }

    public static class Handler
    implements IMessageHandler<ServerConfigList, IMessage> {
        public IMessage onMessage(ServerConfigList message, MessageContext ctx) {
            PlayerComputerStorage.boxCount = message.computerBoxCount;
            PCClientStorage.refreshStore();
            ItemPokeball.allowCapturingOutsideBattle = message.allowCapturingOutsideBattle;
            GuiPixelmonOverlay.hideSpectateMessage(null);
            PixelmonServerConfig.updateFromServer(message);
            return null;
        }
    }
}

