/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.enums.ReceiveType;
import com.pixelmonmod.pixelmon.api.events.PixelmonReceivedEvent;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.customStarters.CustomStarters;
import com.pixelmonmod.pixelmon.customStarters.SelectPokemonController;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SelectPokemon
implements IMessage {
    int starterIndex;

    public SelectPokemon() {
    }

    public SelectPokemon(int starterIndex) {
        this.starterIndex = starterIndex;
    }

    public void fromBytes(ByteBuf buf) {
        this.starterIndex = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.starterIndex);
    }

    public static class Handler
    implements IMessageHandler<SelectPokemon, IMessage> {
        public IMessage onMessage(SelectPokemon message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
            if (optstorage.isPresent()) {
                PlayerStorage storage = optstorage.get();
                if (!SelectPokemonController.isOnList(player)) {
                    return null;
                }
                EntityPixelmon p = (EntityPixelmon)PixelmonEntityList.createEntityByName(SelectPokemonController.getPokemonList((EntityPlayerMP)player)[message.starterIndex].name, player.field_70170_p);
                SelectPokemonController.removePlayer(player);
                p.getLvl().setLevel(CustomStarters.starterLevel);
                p.func_70606_j(p.stats.HP);
                p.loadMoveset();
                p.caughtBall = EnumPokeballs.PokeBall;
                p.friendship.initFromCapture();
                Pixelmon.EVENT_BUS.post((Event)new PixelmonReceivedEvent(player, ReceiveType.SelectPokemon, p));
                storage.addToParty(p);
                storage.starterPicked = true;
            }
            return null;
        }
    }
}

